package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.MaxFiles
import scala.jdk.CollectionConverters._
final case class FilesLimit(
    maxFiles: MaxFiles,
    orderedBy: Option[zio.aws.databrew.model.OrderedBy] = None,
    order: Option[zio.aws.databrew.model.Order] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.FilesLimit = {
    import FilesLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.FilesLimit
      .builder()
      .maxFiles(MaxFiles.unwrap(maxFiles): Integer)
      .optionallyWith(orderedBy.map(value => value.unwrap))(_.orderedBy)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.FilesLimit.ReadOnly =
    zio.aws.databrew.model.FilesLimit.wrap(buildAwsValue())
}
object FilesLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.FilesLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.FilesLimit =
      zio.aws.databrew.model.FilesLimit(
        maxFiles,
        orderedBy.map(value => value),
        order.map(value => value)
      )
    def maxFiles: MaxFiles
    def orderedBy: Option[zio.aws.databrew.model.OrderedBy]
    def order: Option[zio.aws.databrew.model.Order]
    def getMaxFiles: ZIO[Any, Nothing, MaxFiles] = ZIO.succeed(maxFiles)
    def getOrderedBy: ZIO[Any, AwsError, zio.aws.databrew.model.OrderedBy] =
      AwsError.unwrapOptionField("orderedBy", orderedBy)
    def getOrder: ZIO[Any, AwsError, zio.aws.databrew.model.Order] =
      AwsError.unwrapOptionField("order", order)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.FilesLimit
  ) extends zio.aws.databrew.model.FilesLimit.ReadOnly {
    override val maxFiles: MaxFiles =
      zio.aws.databrew.model.primitives.MaxFiles(impl.maxFiles())
    override val orderedBy: Option[zio.aws.databrew.model.OrderedBy] = scala
      .Option(impl.orderedBy())
      .map(value => zio.aws.databrew.model.OrderedBy.wrap(value))
    override val order: Option[zio.aws.databrew.model.Order] = scala
      .Option(impl.order())
      .map(value => zio.aws.databrew.model.Order.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.FilesLimit
  ): zio.aws.databrew.model.FilesLimit.ReadOnly = new Wrapper(impl)
}
