package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databrew.model.primitives.{
  Date,
  LastModifiedBy,
  TagValue,
  ScheduleName,
  Arn,
  CronExpression,
  JobName,
  CreatedBy,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class DescribeScheduleResponse(
    createDate: Option[Date] = None,
    createdBy: Option[CreatedBy] = None,
    jobNames: Option[Iterable[JobName]] = None,
    lastModifiedBy: Option[LastModifiedBy] = None,
    lastModifiedDate: Option[Date] = None,
    resourceArn: Option[Arn] = None,
    cronExpression: Option[CronExpression] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    name: ScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeScheduleResponse = {
    import DescribeScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeScheduleResponse
      .builder()
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        jobNames.map(value =>
          value.map { item =>
            JobName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.jobNames)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        cronExpression.map(value =>
          CronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly =
    zio.aws.databrew.model.DescribeScheduleResponse.wrap(buildAwsValue())
}
object DescribeScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeScheduleResponse =
      zio.aws.databrew.model.DescribeScheduleResponse(
        createDate.map(value => value),
        createdBy.map(value => value),
        jobNames.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        resourceArn.map(value => value),
        cronExpression.map(value => value),
        tags.map(value => value),
        name
      )
    def createDate: Option[Date]
    def createdBy: Option[CreatedBy]
    def jobNames: Option[List[JobName]]
    def lastModifiedBy: Option[LastModifiedBy]
    def lastModifiedDate: Option[Date]
    def resourceArn: Option[Arn]
    def cronExpression: Option[CronExpression]
    def tags: Option[Map[TagKey, TagValue]]
    def name: ScheduleName
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getJobNames: ZIO[Any, AwsError, List[JobName]] =
      AwsError.unwrapOptionField("jobNames", jobNames)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getCronExpression: ZIO[Any, AwsError, CronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeScheduleResponse
  ) extends zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly {
    override val createDate: Option[Date] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val createdBy: Option[CreatedBy] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val jobNames: Option[List[JobName]] = scala
      .Option(impl.jobNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.JobName(item)
        }.toList
      )
    override val lastModifiedBy: Option[LastModifiedBy] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Option[Date] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val cronExpression: Option[CronExpression] = scala
      .Option(impl.cronExpression())
      .map(value => zio.aws.databrew.model.primitives.CronExpression(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeScheduleResponse
  ): zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly = new Wrapper(
    impl
  )
}
