package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.MultiLine
import scala.jdk.CollectionConverters._
final case class JsonOptions(multiLine: Option[MultiLine] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.JsonOptions = {
    import JsonOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.JsonOptions
      .builder()
      .optionallyWith(
        multiLine.map(value => MultiLine.unwrap(value): java.lang.Boolean)
      )(_.multiLine)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.JsonOptions.ReadOnly =
    zio.aws.databrew.model.JsonOptions.wrap(buildAwsValue())
}
object JsonOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.JsonOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.JsonOptions =
      zio.aws.databrew.model.JsonOptions(multiLine.map(value => value))
    def multiLine: Option[MultiLine]
    def getMultiLine: ZIO[Any, AwsError, MultiLine] =
      AwsError.unwrapOptionField("multiLine", multiLine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.JsonOptions
  ) extends zio.aws.databrew.model.JsonOptions.ReadOnly {
    override val multiLine: Option[MultiLine] = scala
      .Option(impl.multiLine())
      .map(value => zio.aws.databrew.model.primitives.MultiLine(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.JsonOptions
  ): zio.aws.databrew.model.JsonOptions.ReadOnly = new Wrapper(impl)
}
