package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class ValidationConfiguration(
    rulesetArn: Arn,
    validationMode: Option[zio.aws.databrew.model.ValidationMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ValidationConfiguration = {
    import ValidationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ValidationConfiguration
      .builder()
      .rulesetArn(Arn.unwrap(rulesetArn): java.lang.String)
      .optionallyWith(validationMode.map(value => value.unwrap))(
        _.validationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ValidationConfiguration.ReadOnly =
    zio.aws.databrew.model.ValidationConfiguration.wrap(buildAwsValue())
}
object ValidationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ValidationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ValidationConfiguration =
      zio.aws.databrew.model
        .ValidationConfiguration(rulesetArn, validationMode.map(value => value))
    def rulesetArn: Arn
    def validationMode: Option[zio.aws.databrew.model.ValidationMode]
    def getRulesetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(rulesetArn)
    def getValidationMode
        : ZIO[Any, AwsError, zio.aws.databrew.model.ValidationMode] =
      AwsError.unwrapOptionField("validationMode", validationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ValidationConfiguration
  ) extends zio.aws.databrew.model.ValidationConfiguration.ReadOnly {
    override val rulesetArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.rulesetArn())
    override val validationMode: Option[zio.aws.databrew.model.ValidationMode] =
      scala
        .Option(impl.validationMode())
        .map(value => zio.aws.databrew.model.ValidationMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ValidationConfiguration
  ): zio.aws.databrew.model.ValidationConfiguration.ReadOnly = new Wrapper(impl)
}
