package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait ThresholdUnit {
  def unwrap: software.amazon.awssdk.services.databrew.model.ThresholdUnit
}
object ThresholdUnit {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.ThresholdUnit
  ): zio.aws.databrew.model.ThresholdUnit = value match {
    case software.amazon.awssdk.services.databrew.model.ThresholdUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.ThresholdUnit.COUNT =>
      val r = COUNT
      r
    case software.amazon.awssdk.services.databrew.model.ThresholdUnit.PERCENTAGE =>
      val r = PERCENTAGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.ThresholdUnit {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdUnit =
      software.amazon.awssdk.services.databrew.model.ThresholdUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object COUNT extends zio.aws.databrew.model.ThresholdUnit {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdUnit =
      software.amazon.awssdk.services.databrew.model.ThresholdUnit.COUNT
  }
  case object PERCENTAGE extends zio.aws.databrew.model.ThresholdUnit {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdUnit =
      software.amazon.awssdk.services.databrew.model.ThresholdUnit.PERCENTAGE
  }
}
