package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait SampleType {
  def unwrap: software.amazon.awssdk.services.databrew.model.SampleType
}
object SampleType {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.SampleType
  ): zio.aws.databrew.model.SampleType = value match {
    case software.amazon.awssdk.services.databrew.model.SampleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.SampleType.FIRST_N =>
      val r = FIRST_N
      r
    case software.amazon.awssdk.services.databrew.model.SampleType.LAST_N =>
      val r = LAST_N
      r
    case software.amazon.awssdk.services.databrew.model.SampleType.RANDOM =>
      val r = RANDOM
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleType =
      software.amazon.awssdk.services.databrew.model.SampleType.UNKNOWN_TO_SDK_VERSION
  }
  case object FIRST_N extends zio.aws.databrew.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleType =
      software.amazon.awssdk.services.databrew.model.SampleType.FIRST_N
  }
  case object LAST_N extends zio.aws.databrew.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleType =
      software.amazon.awssdk.services.databrew.model.SampleType.LAST_N
  }
  case object RANDOM extends zio.aws.databrew.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SampleType =
      software.amazon.awssdk.services.databrew.model.SampleType.RANDOM
  }
}
