package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  ProjectName,
  TagValue,
  Arn,
  DatasetName,
  RecipeName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    datasetName: DatasetName,
    name: ProjectName,
    recipeName: RecipeName,
    sample: Option[zio.aws.databrew.model.Sample] = None,
    roleArn: Arn,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateProjectRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .name(ProjectName.unwrap(name): java.lang.String)
      .recipeName(RecipeName.unwrap(recipeName): java.lang.String)
      .optionallyWith(sample.map(value => value.buildAwsValue()))(_.sample)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateProjectRequest.ReadOnly =
    zio.aws.databrew.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateProjectRequest =
      zio.aws.databrew.model.CreateProjectRequest(
        datasetName,
        name,
        recipeName,
        sample.map(value => value.asEditable),
        roleArn,
        tags.map(value => value)
      )
    def datasetName: DatasetName
    def name: ProjectName
    def recipeName: RecipeName
    def sample: Option[zio.aws.databrew.model.Sample.ReadOnly]
    def roleArn: Arn
    def tags: Option[Map[TagKey, TagValue]]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getRecipeName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(recipeName)
    def getSample: ZIO[Any, AwsError, zio.aws.databrew.model.Sample.ReadOnly] =
      AwsError.unwrapOptionField("sample", sample)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateProjectRequest
  ) extends zio.aws.databrew.model.CreateProjectRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.datasetName())
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val recipeName: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.recipeName())
    override val sample: Option[zio.aws.databrew.model.Sample.ReadOnly] = scala
      .Option(impl.sample())
      .map(value => zio.aws.databrew.model.Sample.wrap(value))
    override val roleArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.roleArn())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateProjectRequest
  ): zio.aws.databrew.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
