package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  QueryString,
  DatabaseTableName,
  GlueConnectionName
}
import scala.jdk.CollectionConverters._
final case class DatabaseInputDefinition(
    glueConnectionName: GlueConnectionName,
    databaseTableName: Option[DatabaseTableName] = None,
    tempDirectory: Option[zio.aws.databrew.model.S3Location] = None,
    queryString: Option[QueryString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DatabaseInputDefinition = {
    import DatabaseInputDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DatabaseInputDefinition
      .builder()
      .glueConnectionName(
        GlueConnectionName.unwrap(glueConnectionName): java.lang.String
      )
      .optionallyWith(
        databaseTableName.map(value =>
          DatabaseTableName.unwrap(value): java.lang.String
        )
      )(_.databaseTableName)
      .optionallyWith(tempDirectory.map(value => value.buildAwsValue()))(
        _.tempDirectory
      )
      .optionallyWith(
        queryString.map(value => QueryString.unwrap(value): java.lang.String)
      )(_.queryString)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DatabaseInputDefinition.ReadOnly =
    zio.aws.databrew.model.DatabaseInputDefinition.wrap(buildAwsValue())
}
object DatabaseInputDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DatabaseInputDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DatabaseInputDefinition =
      zio.aws.databrew.model.DatabaseInputDefinition(
        glueConnectionName,
        databaseTableName.map(value => value),
        tempDirectory.map(value => value.asEditable),
        queryString.map(value => value)
      )
    def glueConnectionName: GlueConnectionName
    def databaseTableName: Option[DatabaseTableName]
    def tempDirectory: Option[zio.aws.databrew.model.S3Location.ReadOnly]
    def queryString: Option[QueryString]
    def getGlueConnectionName: ZIO[Any, Nothing, GlueConnectionName] =
      ZIO.succeed(glueConnectionName)
    def getDatabaseTableName: ZIO[Any, AwsError, DatabaseTableName] =
      AwsError.unwrapOptionField("databaseTableName", databaseTableName)
    def getTempDirectory
        : ZIO[Any, AwsError, zio.aws.databrew.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("tempDirectory", tempDirectory)
    def getQueryString: ZIO[Any, AwsError, QueryString] =
      AwsError.unwrapOptionField("queryString", queryString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DatabaseInputDefinition
  ) extends zio.aws.databrew.model.DatabaseInputDefinition.ReadOnly {
    override val glueConnectionName: GlueConnectionName =
      zio.aws.databrew.model.primitives
        .GlueConnectionName(impl.glueConnectionName())
    override val databaseTableName: Option[DatabaseTableName] = scala
      .Option(impl.databaseTableName())
      .map(value => zio.aws.databrew.model.primitives.DatabaseTableName(value))
    override val tempDirectory
        : Option[zio.aws.databrew.model.S3Location.ReadOnly] = scala
      .Option(impl.tempDirectory())
      .map(value => zio.aws.databrew.model.S3Location.wrap(value))
    override val queryString: Option[QueryString] = scala
      .Option(impl.queryString())
      .map(value => zio.aws.databrew.model.primitives.QueryString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DatabaseInputDefinition
  ): zio.aws.databrew.model.DatabaseInputDefinition.ReadOnly = new Wrapper(impl)
}
