package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  JobRunId,
  Date,
  StartedBy,
  ExecutionTime,
  DatasetName,
  Attempt,
  JobName,
  LogGroupName,
  JobRunErrorMessage
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class JobRun(
    attempt: Option[Attempt] = None,
    completedOn: Option[Date] = None,
    datasetName: Option[DatasetName] = None,
    errorMessage: Option[JobRunErrorMessage] = None,
    executionTime: Option[ExecutionTime] = None,
    jobName: Option[JobName] = None,
    runId: Option[JobRunId] = None,
    state: Option[zio.aws.databrew.model.JobRunState] = None,
    logSubscription: Option[zio.aws.databrew.model.LogSubscription] = None,
    logGroupName: Option[LogGroupName] = None,
    outputs: Option[Iterable[zio.aws.databrew.model.Output]] = None,
    dataCatalogOutputs: Option[
      Iterable[zio.aws.databrew.model.DataCatalogOutput]
    ] = None,
    databaseOutputs: Option[Iterable[zio.aws.databrew.model.DatabaseOutput]] =
      None,
    recipeReference: Option[zio.aws.databrew.model.RecipeReference] = None,
    startedBy: Option[StartedBy] = None,
    startedOn: Option[Date] = None,
    jobSample: Option[zio.aws.databrew.model.JobSample] = None,
    validationConfigurations: Option[
      Iterable[zio.aws.databrew.model.ValidationConfiguration]
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.JobRun = {
    import JobRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.JobRun
      .builder()
      .optionallyWith(attempt.map(value => Attempt.unwrap(value): Integer))(
        _.attempt
      )
      .optionallyWith(completedOn.map(value => Date.unwrap(value): Instant))(
        _.completedOn
      )
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        errorMessage.map(value =>
          JobRunErrorMessage.unwrap(value): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        executionTime.map(value => ExecutionTime.unwrap(value): Integer)
      )(_.executionTime)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        runId.map(value => JobRunId.unwrap(value): java.lang.String)
      )(_.runId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(logSubscription.map(value => value.unwrap))(
        _.logSubscription
      )
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCatalogOutputs)
      .optionallyWith(
        databaseOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseOutputs)
      .optionallyWith(recipeReference.map(value => value.buildAwsValue()))(
        _.recipeReference
      )
      .optionallyWith(
        startedBy.map(value => StartedBy.unwrap(value): java.lang.String)
      )(_.startedBy)
      .optionallyWith(startedOn.map(value => Date.unwrap(value): Instant))(
        _.startedOn
      )
      .optionallyWith(jobSample.map(value => value.buildAwsValue()))(
        _.jobSample
      )
      .optionallyWith(
        validationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.JobRun.ReadOnly =
    zio.aws.databrew.model.JobRun.wrap(buildAwsValue())
}
object JobRun {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.JobRun] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.JobRun =
      zio.aws.databrew.model.JobRun(
        attempt.map(value => value),
        completedOn.map(value => value),
        datasetName.map(value => value),
        errorMessage.map(value => value),
        executionTime.map(value => value),
        jobName.map(value => value),
        runId.map(value => value),
        state.map(value => value),
        logSubscription.map(value => value),
        logGroupName.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        databaseOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recipeReference.map(value => value.asEditable),
        startedBy.map(value => value),
        startedOn.map(value => value),
        jobSample.map(value => value.asEditable),
        validationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attempt: Option[Attempt]
    def completedOn: Option[Date]
    def datasetName: Option[DatasetName]
    def errorMessage: Option[JobRunErrorMessage]
    def executionTime: Option[ExecutionTime]
    def jobName: Option[JobName]
    def runId: Option[JobRunId]
    def state: Option[zio.aws.databrew.model.JobRunState]
    def logSubscription: Option[zio.aws.databrew.model.LogSubscription]
    def logGroupName: Option[LogGroupName]
    def outputs: Option[List[zio.aws.databrew.model.Output.ReadOnly]]
    def dataCatalogOutputs
        : Option[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]]
    def databaseOutputs
        : Option[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]]
    def recipeReference: Option[zio.aws.databrew.model.RecipeReference.ReadOnly]
    def startedBy: Option[StartedBy]
    def startedOn: Option[Date]
    def jobSample: Option[zio.aws.databrew.model.JobSample.ReadOnly]
    def validationConfigurations
        : Option[List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]]
    def getAttempt: ZIO[Any, AwsError, Attempt] =
      AwsError.unwrapOptionField("attempt", attempt)
    def getCompletedOn: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("completedOn", completedOn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getErrorMessage: ZIO[Any, AwsError, JobRunErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getExecutionTime: ZIO[Any, AwsError, ExecutionTime] =
      AwsError.unwrapOptionField("executionTime", executionTime)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getRunId: ZIO[Any, AwsError, JobRunId] =
      AwsError.unwrapOptionField("runId", runId)
    def getState: ZIO[Any, AwsError, zio.aws.databrew.model.JobRunState] =
      AwsError.unwrapOptionField("state", state)
    def getLogSubscription
        : ZIO[Any, AwsError, zio.aws.databrew.model.LogSubscription] =
      AwsError.unwrapOptionField("logSubscription", logSubscription)
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getDataCatalogOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DataCatalogOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCatalogOutputs", dataCatalogOutputs)
    def getDatabaseOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DatabaseOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("databaseOutputs", databaseOutputs)
    def getRecipeReference
        : ZIO[Any, AwsError, zio.aws.databrew.model.RecipeReference.ReadOnly] =
      AwsError.unwrapOptionField("recipeReference", recipeReference)
    def getStartedBy: ZIO[Any, AwsError, StartedBy] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getStartedOn: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startedOn", startedOn)
    def getJobSample
        : ZIO[Any, AwsError, zio.aws.databrew.model.JobSample.ReadOnly] =
      AwsError.unwrapOptionField("jobSample", jobSample)
    def getValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.ValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validationConfigurations",
      validationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.JobRun
  ) extends zio.aws.databrew.model.JobRun.ReadOnly {
    override val attempt: Option[Attempt] = scala
      .Option(impl.attempt())
      .map(value => zio.aws.databrew.model.primitives.Attempt(value))
    override val completedOn: Option[Date] = scala
      .Option(impl.completedOn())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val errorMessage: Option[JobRunErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.databrew.model.primitives.JobRunErrorMessage(value))
    override val executionTime: Option[ExecutionTime] = scala
      .Option(impl.executionTime())
      .map(value => zio.aws.databrew.model.primitives.ExecutionTime(value))
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.databrew.model.primitives.JobName(value))
    override val runId: Option[JobRunId] = scala
      .Option(impl.runId())
      .map(value => zio.aws.databrew.model.primitives.JobRunId(value))
    override val state: Option[zio.aws.databrew.model.JobRunState] = scala
      .Option(impl.state())
      .map(value => zio.aws.databrew.model.JobRunState.wrap(value))
    override val logSubscription
        : Option[zio.aws.databrew.model.LogSubscription] = scala
      .Option(impl.logSubscription())
      .map(value => zio.aws.databrew.model.LogSubscription.wrap(value))
    override val logGroupName: Option[LogGroupName] = scala
      .Option(impl.logGroupName())
      .map(value => zio.aws.databrew.model.primitives.LogGroupName(value))
    override val outputs: Option[List[zio.aws.databrew.model.Output.ReadOnly]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Output.wrap(item)
          }.toList
        )
    override val dataCatalogOutputs
        : Option[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]] =
      scala
        .Option(impl.dataCatalogOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DataCatalogOutput.wrap(item)
          }.toList
        )
    override val databaseOutputs
        : Option[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]] = scala
      .Option(impl.databaseOutputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.DatabaseOutput.wrap(item)
        }.toList
      )
    override val recipeReference
        : Option[zio.aws.databrew.model.RecipeReference.ReadOnly] = scala
      .Option(impl.recipeReference())
      .map(value => zio.aws.databrew.model.RecipeReference.wrap(value))
    override val startedBy: Option[StartedBy] = scala
      .Option(impl.startedBy())
      .map(value => zio.aws.databrew.model.primitives.StartedBy(value))
    override val startedOn: Option[Date] = scala
      .Option(impl.startedOn())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val jobSample: Option[zio.aws.databrew.model.JobSample.ReadOnly] =
      scala
        .Option(impl.jobSample())
        .map(value => zio.aws.databrew.model.JobSample.wrap(value))
    override val validationConfigurations: Option[
      List[zio.aws.databrew.model.ValidationConfiguration.ReadOnly]
    ] = scala
      .Option(impl.validationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.ValidationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.JobRun
  ): zio.aws.databrew.model.JobRun.ReadOnly = new Wrapper(impl)
}
