package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{RecipeName, NextToken, MaxResults100}
import scala.jdk.CollectionConverters._
final case class ListRecipeVersionsRequest(
    maxResults: Option[MaxResults100] = None,
    nextToken: Option[NextToken] = None,
    name: RecipeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest = {
    import ListRecipeVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .name(RecipeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRecipeVersionsRequest.ReadOnly =
    zio.aws.databrew.model.ListRecipeVersionsRequest.wrap(buildAwsValue())
}
object ListRecipeVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRecipeVersionsRequest =
      zio.aws.databrew.model.ListRecipeVersionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        name
      )
    def maxResults: Option[MaxResults100]
    def nextToken: Option[NextToken]
    def name: RecipeName
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
  ) extends zio.aws.databrew.model.ListRecipeVersionsRequest.ReadOnly {
    override val maxResults: Option[MaxResults100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
  ): zio.aws.databrew.model.ListRecipeVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
