package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RulesetName
import scala.jdk.CollectionConverters._
final case class DeleteRulesetRequest(name: RulesetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteRulesetRequest = {
    import DeleteRulesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteRulesetRequest
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteRulesetRequest.ReadOnly =
    zio.aws.databrew.model.DeleteRulesetRequest.wrap(buildAwsValue())
}
object DeleteRulesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteRulesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteRulesetRequest =
      zio.aws.databrew.model.DeleteRulesetRequest(name)
    def name: RulesetName
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRulesetRequest
  ) extends zio.aws.databrew.model.DeleteRulesetRequest.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRulesetRequest
  ): zio.aws.databrew.model.DeleteRulesetRequest.ReadOnly = new Wrapper(impl)
}
