package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ScheduleName
import scala.jdk.CollectionConverters._
final case class CreateScheduleResponse(name: ScheduleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateScheduleResponse = {
    import CreateScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateScheduleResponse
      .builder()
      .name(ScheduleName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateScheduleResponse.ReadOnly =
    zio.aws.databrew.model.CreateScheduleResponse.wrap(buildAwsValue())
}
object CreateScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateScheduleResponse =
      zio.aws.databrew.model.CreateScheduleResponse(name)
    def name: ScheduleName
    def getName: ZIO[Any, Nothing, ScheduleName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateScheduleResponse
  ) extends zio.aws.databrew.model.CreateScheduleResponse.ReadOnly {
    override val name: ScheduleName =
      zio.aws.databrew.model.primitives.ScheduleName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateScheduleResponse
  ): zio.aws.databrew.model.CreateScheduleResponse.ReadOnly = new Wrapper(impl)
}
