package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRecipesResponse(
    recipes: Iterable[zio.aws.databrew.model.Recipe],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRecipesResponse = {
    import ListRecipesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRecipesResponse
      .builder()
      .recipes(recipes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRecipesResponse.ReadOnly =
    zio.aws.databrew.model.ListRecipesResponse.wrap(buildAwsValue())
}
object ListRecipesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRecipesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRecipesResponse =
      zio.aws.databrew.model.ListRecipesResponse(
        recipes.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def recipes: List[zio.aws.databrew.model.Recipe.ReadOnly]
    def nextToken: Option[NextToken]
    def getRecipes
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Recipe.ReadOnly]] =
      ZIO.succeed(recipes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipesResponse
  ) extends zio.aws.databrew.model.ListRecipesResponse.ReadOnly {
    override val recipes: List[zio.aws.databrew.model.Recipe.ReadOnly] = impl
      .recipes()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Recipe.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipesResponse
  ): zio.aws.databrew.model.ListRecipesResponse.ReadOnly = new Wrapper(impl)
}
