package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait ValidationMode {
  def unwrap: software.amazon.awssdk.services.databrew.model.ValidationMode
}
object ValidationMode {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.ValidationMode
  ): zio.aws.databrew.model.ValidationMode = value match {
    case software.amazon.awssdk.services.databrew.model.ValidationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.ValidationMode.CHECK_ALL =>
      val r = CHECK_ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databrew.model.ValidationMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ValidationMode =
      software.amazon.awssdk.services.databrew.model.ValidationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CHECK_ALL extends zio.aws.databrew.model.ValidationMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ValidationMode =
      software.amazon.awssdk.services.databrew.model.ValidationMode.CHECK_ALL
  }
}
