package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.ColumnName
import scala.jdk.CollectionConverters._
final case class ColumnSelector(
    regex: Option[ColumnName] = None,
    name: Option[ColumnName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ColumnSelector = {
    import ColumnSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ColumnSelector
      .builder()
      .optionallyWith(
        regex.map(value => ColumnName.unwrap(value): java.lang.String)
      )(_.regex)
      .optionallyWith(
        name.map(value => ColumnName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ColumnSelector.ReadOnly =
    zio.aws.databrew.model.ColumnSelector.wrap(buildAwsValue())
}
object ColumnSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ColumnSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ColumnSelector =
      zio.aws.databrew.model
        .ColumnSelector(regex.map(value => value), name.map(value => value))
    def regex: Option[ColumnName]
    def name: Option[ColumnName]
    def getRegex: ZIO[Any, AwsError, ColumnName] =
      AwsError.unwrapOptionField("regex", regex)
    def getName: ZIO[Any, AwsError, ColumnName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ColumnSelector
  ) extends zio.aws.databrew.model.ColumnSelector.ReadOnly {
    override val regex: Option[ColumnName] = scala
      .Option(impl.regex())
      .map(value => zio.aws.databrew.model.primitives.ColumnName(value))
    override val name: Option[ColumnName] = scala
      .Option(impl.name())
      .map(value => zio.aws.databrew.model.primitives.ColumnName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ColumnSelector
  ): zio.aws.databrew.model.ColumnSelector.ReadOnly = new Wrapper(impl)
}
