package zio.aws.databrew
import zio.aws.databrew.model.UpdateProfileJobResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.databrew.model.{
  DescribeProjectResponse,
  CreateRecipeResponse,
  JobRun,
  CreateRecipeJobRequest,
  CreateScheduleResponse,
  UpdateScheduleResponse,
  PublishRecipeRequest,
  ListRecipeVersionsRequest,
  UpdateProfileJobResponse,
  ListRulesetsRequest,
  DescribeDatasetResponse,
  StartProjectSessionResponse,
  CreateProfileJobResponse,
  CreateDatasetRequest,
  CreateRecipeJobResponse,
  ListSchedulesRequest,
  CreateProjectRequest,
  Schedule,
  CreateRulesetResponse,
  CreateProfileJobRequest,
  ListRulesetsResponse,
  StartProjectSessionRequest,
  DeleteScheduleResponse,
  ListJobRunsRequest,
  ListProjectsResponse,
  DeleteRulesetResponse,
  ListJobsRequest,
  DeleteScheduleRequest,
  StartJobRunRequest,
  DescribeJobRunRequest,
  UpdateRecipeResponse,
  SendProjectSessionActionResponse,
  DescribeScheduleResponse,
  DescribeJobRequest,
  Recipe,
  DescribeDatasetRequest,
  DescribeJobResponse,
  ListTagsForResourceRequest,
  Project,
  CreateDatasetResponse,
  ListJobRunsResponse,
  DescribeRecipeRequest,
  DescribeRecipeResponse,
  DeleteJobResponse,
  StopJobRunRequest,
  CreateScheduleRequest,
  DeleteRulesetRequest,
  UpdateProjectRequest,
  ListDatasetsRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteJobRequest,
  DeleteRecipeVersionResponse,
  ListRecipesResponse,
  CreateRulesetRequest,
  DeleteProjectRequest,
  CreateProjectResponse,
  ListRecipeVersionsResponse,
  UpdateRecipeRequest,
  Job,
  DescribeRulesetRequest,
  DeleteDatasetRequest,
  UpdateRulesetResponse,
  SendProjectSessionActionRequest,
  DeleteDatasetResponse,
  PublishRecipeResponse,
  ListProjectsRequest,
  DescribeRulesetResponse,
  BatchDeleteRecipeVersionResponse,
  UntagResourceRequest,
  BatchDeleteRecipeVersionRequest,
  CreateRecipeRequest,
  ListRecipesRequest,
  UpdateRecipeJobResponse,
  Dataset,
  DescribeJobRunResponse,
  RulesetItem,
  ListDatasetsResponse,
  UpdateRulesetRequest,
  ListJobsResponse,
  StopJobRunResponse,
  UpdateDatasetRequest,
  UpdateProjectResponse,
  UpdateScheduleRequest,
  StartJobRunResponse,
  TagResourceResponse,
  ListSchedulesResponse,
  DeleteProjectResponse,
  DescribeProjectRequest,
  TagResourceRequest,
  DeleteRecipeVersionRequest,
  UpdateProfileJobRequest,
  DescribeScheduleRequest,
  UpdateDatasetResponse,
  UpdateRecipeJobRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.databrew.{
  DataBrewAsyncClientBuilder,
  DataBrewAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait DataBrew extends AspectSupport[DataBrew] {
  val api: DataBrewAsyncClient
  def createDataset(
      request: zio.aws.databrew.model.CreateDatasetRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateDatasetResponse.ReadOnly]
  def batchDeleteRecipeVersion(
      request: zio.aws.databrew.model.BatchDeleteRecipeVersionRequest
  ): IO[
    AwsError,
    zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly
  ]
  def describeJob(
      request: zio.aws.databrew.model.DescribeJobRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeJobResponse.ReadOnly]
  def createSchedule(
      request: zio.aws.databrew.model.CreateScheduleRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateScheduleResponse.ReadOnly]
  def listSchedules(
      request: zio.aws.databrew.model.ListSchedulesRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.Schedule.ReadOnly]
  def listSchedulesPaginated(
      request: zio.aws.databrew.model.ListSchedulesRequest
  ): IO[AwsError, zio.aws.databrew.model.ListSchedulesResponse.ReadOnly]
  def updateProject(
      request: zio.aws.databrew.model.UpdateProjectRequest
  ): IO[AwsError, zio.aws.databrew.model.UpdateProjectResponse.ReadOnly]
  def describeJobRun(
      request: zio.aws.databrew.model.DescribeJobRunRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly]
  def listJobRuns(
      request: zio.aws.databrew.model.ListJobRunsRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.JobRun.ReadOnly]
  def listJobRunsPaginated(
      request: zio.aws.databrew.model.ListJobRunsRequest
  ): IO[AwsError, zio.aws.databrew.model.ListJobRunsResponse.ReadOnly]
  def createRuleset(
      request: zio.aws.databrew.model.CreateRulesetRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateRulesetResponse.ReadOnly]
  def updateSchedule(
      request: zio.aws.databrew.model.UpdateScheduleRequest
  ): IO[AwsError, zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly]
  def deleteRuleset(
      request: zio.aws.databrew.model.DeleteRulesetRequest
  ): IO[AwsError, zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly]
  def stopJobRun(
      request: zio.aws.databrew.model.StopJobRunRequest
  ): IO[AwsError, zio.aws.databrew.model.StopJobRunResponse.ReadOnly]
  def listRulesets(
      request: zio.aws.databrew.model.ListRulesetsRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.RulesetItem.ReadOnly]
  def listRulesetsPaginated(
      request: zio.aws.databrew.model.ListRulesetsRequest
  ): IO[AwsError, zio.aws.databrew.model.ListRulesetsResponse.ReadOnly]
  def describeDataset(
      request: zio.aws.databrew.model.DescribeDatasetRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly]
  def listProjects(
      request: zio.aws.databrew.model.ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.Project.ReadOnly]
  def listProjectsPaginated(
      request: zio.aws.databrew.model.ListProjectsRequest
  ): IO[AwsError, zio.aws.databrew.model.ListProjectsResponse.ReadOnly]
  def createProfileJob(
      request: zio.aws.databrew.model.CreateProfileJobRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly]
  def describeRecipe(
      request: zio.aws.databrew.model.DescribeRecipeRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly]
  def updateRecipeJob(
      request: zio.aws.databrew.model.UpdateRecipeJobRequest
  ): IO[AwsError, zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly]
  def updateDataset(
      request: zio.aws.databrew.model.UpdateDatasetRequest
  ): IO[AwsError, zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly]
  def describeRuleset(
      request: zio.aws.databrew.model.DescribeRulesetRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly]
  def untagResource(
      request: zio.aws.databrew.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.databrew.model.UntagResourceResponse.ReadOnly]
  def createProject(
      request: zio.aws.databrew.model.CreateProjectRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateProjectResponse.ReadOnly]
  def sendProjectSessionAction(
      request: zio.aws.databrew.model.SendProjectSessionActionRequest
  ): IO[
    AwsError,
    zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly
  ]
  def startProjectSession(
      request: zio.aws.databrew.model.StartProjectSessionRequest
  ): IO[AwsError, zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly]
  def describeSchedule(
      request: zio.aws.databrew.model.DescribeScheduleRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly]
  def updateRecipe(
      request: zio.aws.databrew.model.UpdateRecipeRequest
  ): IO[AwsError, zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly]
  def listDatasets(
      request: zio.aws.databrew.model.ListDatasetsRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.Dataset.ReadOnly]
  def listDatasetsPaginated(
      request: zio.aws.databrew.model.ListDatasetsRequest
  ): IO[AwsError, zio.aws.databrew.model.ListDatasetsResponse.ReadOnly]
  def updateRuleset(
      request: zio.aws.databrew.model.UpdateRulesetRequest
  ): IO[AwsError, zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.databrew.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.databrew.model.ListTagsForResourceResponse.ReadOnly]
  def createRecipe(
      request: zio.aws.databrew.model.CreateRecipeRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateRecipeResponse.ReadOnly]
  def describeProject(
      request: zio.aws.databrew.model.DescribeProjectRequest
  ): IO[AwsError, zio.aws.databrew.model.DescribeProjectResponse.ReadOnly]
  def listJobs(
      request: zio.aws.databrew.model.ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.Job.ReadOnly]
  def listJobsPaginated(
      request: zio.aws.databrew.model.ListJobsRequest
  ): IO[AwsError, zio.aws.databrew.model.ListJobsResponse.ReadOnly]
  def tagResource(
      request: zio.aws.databrew.model.TagResourceRequest
  ): IO[AwsError, zio.aws.databrew.model.TagResourceResponse.ReadOnly]
  def updateProfileJob(
      request: zio.aws.databrew.model.UpdateProfileJobRequest
  ): IO[AwsError, ReadOnly]
  def createRecipeJob(
      request: zio.aws.databrew.model.CreateRecipeJobRequest
  ): IO[AwsError, zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly]
  def deleteDataset(
      request: zio.aws.databrew.model.DeleteDatasetRequest
  ): IO[AwsError, zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly]
  def deleteRecipeVersion(
      request: zio.aws.databrew.model.DeleteRecipeVersionRequest
  ): IO[AwsError, zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly]
  def deleteProject(
      request: zio.aws.databrew.model.DeleteProjectRequest
  ): IO[AwsError, zio.aws.databrew.model.DeleteProjectResponse.ReadOnly]
  def deleteSchedule(
      request: zio.aws.databrew.model.DeleteScheduleRequest
  ): IO[AwsError, zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly]
  def startJobRun(
      request: zio.aws.databrew.model.StartJobRunRequest
  ): IO[AwsError, zio.aws.databrew.model.StartJobRunResponse.ReadOnly]
  def listRecipeVersions(
      request: zio.aws.databrew.model.ListRecipeVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.Recipe.ReadOnly]
  def listRecipeVersionsPaginated(
      request: zio.aws.databrew.model.ListRecipeVersionsRequest
  ): IO[AwsError, zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly]
  def deleteJob(
      request: zio.aws.databrew.model.DeleteJobRequest
  ): IO[AwsError, zio.aws.databrew.model.DeleteJobResponse.ReadOnly]
  def publishRecipe(
      request: zio.aws.databrew.model.PublishRecipeRequest
  ): IO[AwsError, zio.aws.databrew.model.PublishRecipeResponse.ReadOnly]
  def listRecipes(
      request: zio.aws.databrew.model.ListRecipesRequest
  ): ZStream[Any, AwsError, zio.aws.databrew.model.Recipe.ReadOnly]
  def listRecipesPaginated(
      request: zio.aws.databrew.model.ListRecipesRequest
  ): IO[AwsError, zio.aws.databrew.model.ListRecipesResponse.ReadOnly]
}
object DataBrew {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DataBrew] = customized(
    identity
  )
  def customized(
      customization: DataBrewAsyncClientBuilder => DataBrewAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DataBrew] = managed(
    customization
  ).toLayer
  def managed(
      customization: DataBrewAsyncClientBuilder => DataBrewAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, DataBrew] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = DataBrewAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DataBrewAsyncClient, DataBrewAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[DataBrewAsyncClient, DataBrewAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new DataBrewImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DataBrewImpl[R](
      override val api: DataBrewAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DataBrew
      with AwsServiceBase[R] {
    override val serviceName: String = "DataBrew"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DataBrewImpl[R1] = new DataBrewImpl(api, newAspect, r)
    def createDataset(
        request: zio.aws.databrew.model.CreateDatasetRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[CreateDatasetRequest, CreateDatasetResponse](
        "createDataset",
        api.createDataset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def batchDeleteRecipeVersion(
        request: zio.aws.databrew.model.BatchDeleteRecipeVersionRequest
    ): IO[
      AwsError,
      zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDeleteRecipeVersionRequest,
      BatchDeleteRecipeVersionResponse
    ]("batchDeleteRecipeVersion", api.batchDeleteRecipeVersion)(
      request.buildAwsValue()
    ).map(zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.wrap)
      .provideEnvironment(r)
    def describeJob(
        request: zio.aws.databrew.model.DescribeJobRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeJobResponse.ReadOnly] =
      asyncRequestResponse[DescribeJobRequest, DescribeJobResponse](
        "describeJob",
        api.describeJob
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeJobResponse.wrap)
        .provideEnvironment(r)
    def createSchedule(
        request: zio.aws.databrew.model.CreateScheduleRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateScheduleResponse.ReadOnly] =
      asyncRequestResponse[CreateScheduleRequest, CreateScheduleResponse](
        "createSchedule",
        api.createSchedule
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateScheduleResponse.wrap)
        .provideEnvironment(r)
    def listSchedules(
        request: zio.aws.databrew.model.ListSchedulesRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.Schedule.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListSchedulesRequest,
        ListSchedulesResponse,
        Schedule
      ](
        "listSchedules",
        api.listSchedules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.schedules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.Schedule.wrap(item))
        .provideEnvironment(r)
    def listSchedulesPaginated(
        request: zio.aws.databrew.model.ListSchedulesRequest
    ): IO[AwsError, zio.aws.databrew.model.ListSchedulesResponse.ReadOnly] =
      asyncRequestResponse[ListSchedulesRequest, ListSchedulesResponse](
        "listSchedules",
        api.listSchedules
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListSchedulesResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: zio.aws.databrew.model.UpdateProjectRequest
    ): IO[AwsError, zio.aws.databrew.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[UpdateProjectRequest, UpdateProjectResponse](
        "updateProject",
        api.updateProject
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def describeJobRun(
        request: zio.aws.databrew.model.DescribeJobRunRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly] =
      asyncRequestResponse[DescribeJobRunRequest, DescribeJobRunResponse](
        "describeJobRun",
        api.describeJobRun
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeJobRunResponse.wrap)
        .provideEnvironment(r)
    def listJobRuns(
        request: zio.aws.databrew.model.ListJobRunsRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.JobRun.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListJobRunsRequest,
        ListJobRunsResponse,
        JobRun
      ](
        "listJobRuns",
        api.listJobRuns,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.jobRuns().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.JobRun.wrap(item))
        .provideEnvironment(r)
    def listJobRunsPaginated(
        request: zio.aws.databrew.model.ListJobRunsRequest
    ): IO[AwsError, zio.aws.databrew.model.ListJobRunsResponse.ReadOnly] =
      asyncRequestResponse[ListJobRunsRequest, ListJobRunsResponse](
        "listJobRuns",
        api.listJobRuns
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListJobRunsResponse.wrap)
        .provideEnvironment(r)
    def createRuleset(
        request: zio.aws.databrew.model.CreateRulesetRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateRulesetResponse.ReadOnly] =
      asyncRequestResponse[CreateRulesetRequest, CreateRulesetResponse](
        "createRuleset",
        api.createRuleset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateRulesetResponse.wrap)
        .provideEnvironment(r)
    def updateSchedule(
        request: zio.aws.databrew.model.UpdateScheduleRequest
    ): IO[AwsError, zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly] =
      asyncRequestResponse[UpdateScheduleRequest, UpdateScheduleResponse](
        "updateSchedule",
        api.updateSchedule
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateScheduleResponse.wrap)
        .provideEnvironment(r)
    def deleteRuleset(
        request: zio.aws.databrew.model.DeleteRulesetRequest
    ): IO[AwsError, zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly] =
      asyncRequestResponse[DeleteRulesetRequest, DeleteRulesetResponse](
        "deleteRuleset",
        api.deleteRuleset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DeleteRulesetResponse.wrap)
        .provideEnvironment(r)
    def stopJobRun(
        request: zio.aws.databrew.model.StopJobRunRequest
    ): IO[AwsError, zio.aws.databrew.model.StopJobRunResponse.ReadOnly] =
      asyncRequestResponse[StopJobRunRequest, StopJobRunResponse](
        "stopJobRun",
        api.stopJobRun
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.StopJobRunResponse.wrap)
        .provideEnvironment(r)
    def listRulesets(
        request: zio.aws.databrew.model.ListRulesetsRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.RulesetItem.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListRulesetsRequest,
        ListRulesetsResponse,
        RulesetItem
      ](
        "listRulesets",
        api.listRulesets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.rulesets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.RulesetItem.wrap(item))
        .provideEnvironment(r)
    def listRulesetsPaginated(
        request: zio.aws.databrew.model.ListRulesetsRequest
    ): IO[AwsError, zio.aws.databrew.model.ListRulesetsResponse.ReadOnly] =
      asyncRequestResponse[ListRulesetsRequest, ListRulesetsResponse](
        "listRulesets",
        api.listRulesets
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListRulesetsResponse.wrap)
        .provideEnvironment(r)
    def describeDataset(
        request: zio.aws.databrew.model.DescribeDatasetRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly] =
      asyncRequestResponse[DescribeDatasetRequest, DescribeDatasetResponse](
        "describeDataset",
        api.describeDataset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeDatasetResponse.wrap)
        .provideEnvironment(r)
    def listProjects(
        request: zio.aws.databrew.model.ListProjectsRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.Project.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListProjectsRequest,
        ListProjectsResponse,
        Project
      ](
        "listProjects",
        api.listProjects,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.projects().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.Project.wrap(item))
        .provideEnvironment(r)
    def listProjectsPaginated(
        request: zio.aws.databrew.model.ListProjectsRequest
    ): IO[AwsError, zio.aws.databrew.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[ListProjectsRequest, ListProjectsResponse](
        "listProjects",
        api.listProjects
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def createProfileJob(
        request: zio.aws.databrew.model.CreateProfileJobRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly] =
      asyncRequestResponse[CreateProfileJobRequest, CreateProfileJobResponse](
        "createProfileJob",
        api.createProfileJob
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateProfileJobResponse.wrap)
        .provideEnvironment(r)
    def describeRecipe(
        request: zio.aws.databrew.model.DescribeRecipeRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly] =
      asyncRequestResponse[DescribeRecipeRequest, DescribeRecipeResponse](
        "describeRecipe",
        api.describeRecipe
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeRecipeResponse.wrap)
        .provideEnvironment(r)
    def updateRecipeJob(
        request: zio.aws.databrew.model.UpdateRecipeJobRequest
    ): IO[AwsError, zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly] =
      asyncRequestResponse[UpdateRecipeJobRequest, UpdateRecipeJobResponse](
        "updateRecipeJob",
        api.updateRecipeJob
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateRecipeJobResponse.wrap)
        .provideEnvironment(r)
    def updateDataset(
        request: zio.aws.databrew.model.UpdateDatasetRequest
    ): IO[AwsError, zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly] =
      asyncRequestResponse[UpdateDatasetRequest, UpdateDatasetResponse](
        "updateDataset",
        api.updateDataset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateDatasetResponse.wrap)
        .provideEnvironment(r)
    def describeRuleset(
        request: zio.aws.databrew.model.DescribeRulesetRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly] =
      asyncRequestResponse[DescribeRulesetRequest, DescribeRulesetResponse](
        "describeRuleset",
        api.describeRuleset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeRulesetResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.databrew.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.databrew.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: zio.aws.databrew.model.CreateProjectRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[CreateProjectRequest, CreateProjectResponse](
        "createProject",
        api.createProject
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def sendProjectSessionAction(
        request: zio.aws.databrew.model.SendProjectSessionActionRequest
    ): IO[
      AwsError,
      zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly
    ] = asyncRequestResponse[
      SendProjectSessionActionRequest,
      SendProjectSessionActionResponse
    ]("sendProjectSessionAction", api.sendProjectSessionAction)(
      request.buildAwsValue()
    ).map(zio.aws.databrew.model.SendProjectSessionActionResponse.wrap)
      .provideEnvironment(r)
    def startProjectSession(
        request: zio.aws.databrew.model.StartProjectSessionRequest
    ): IO[
      AwsError,
      zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartProjectSessionRequest,
      StartProjectSessionResponse
    ]("startProjectSession", api.startProjectSession)(request.buildAwsValue())
      .map(zio.aws.databrew.model.StartProjectSessionResponse.wrap)
      .provideEnvironment(r)
    def describeSchedule(
        request: zio.aws.databrew.model.DescribeScheduleRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly] =
      asyncRequestResponse[DescribeScheduleRequest, DescribeScheduleResponse](
        "describeSchedule",
        api.describeSchedule
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeScheduleResponse.wrap)
        .provideEnvironment(r)
    def updateRecipe(
        request: zio.aws.databrew.model.UpdateRecipeRequest
    ): IO[AwsError, zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly] =
      asyncRequestResponse[UpdateRecipeRequest, UpdateRecipeResponse](
        "updateRecipe",
        api.updateRecipe
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateRecipeResponse.wrap)
        .provideEnvironment(r)
    def listDatasets(
        request: zio.aws.databrew.model.ListDatasetsRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.Dataset.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDatasetsRequest,
        ListDatasetsResponse,
        Dataset
      ](
        "listDatasets",
        api.listDatasets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.datasets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.Dataset.wrap(item))
        .provideEnvironment(r)
    def listDatasetsPaginated(
        request: zio.aws.databrew.model.ListDatasetsRequest
    ): IO[AwsError, zio.aws.databrew.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[ListDatasetsRequest, ListDatasetsResponse](
        "listDatasets",
        api.listDatasets
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def updateRuleset(
        request: zio.aws.databrew.model.UpdateRulesetRequest
    ): IO[AwsError, zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly] =
      asyncRequestResponse[UpdateRulesetRequest, UpdateRulesetResponse](
        "updateRuleset",
        api.updateRuleset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateRulesetResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.databrew.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.databrew.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.databrew.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createRecipe(
        request: zio.aws.databrew.model.CreateRecipeRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateRecipeResponse.ReadOnly] =
      asyncRequestResponse[CreateRecipeRequest, CreateRecipeResponse](
        "createRecipe",
        api.createRecipe
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateRecipeResponse.wrap)
        .provideEnvironment(r)
    def describeProject(
        request: zio.aws.databrew.model.DescribeProjectRequest
    ): IO[AwsError, zio.aws.databrew.model.DescribeProjectResponse.ReadOnly] =
      asyncRequestResponse[DescribeProjectRequest, DescribeProjectResponse](
        "describeProject",
        api.describeProject
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DescribeProjectResponse.wrap)
        .provideEnvironment(r)
    def listJobs(
        request: zio.aws.databrew.model.ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.Job.ReadOnly] =
      asyncSimplePaginatedRequest[ListJobsRequest, ListJobsResponse, Job](
        "listJobs",
        api.listJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.jobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.Job.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: zio.aws.databrew.model.ListJobsRequest
    ): IO[AwsError, zio.aws.databrew.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[ListJobsRequest, ListJobsResponse](
        "listJobs",
        api.listJobs
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.databrew.model.TagResourceRequest
    ): IO[AwsError, zio.aws.databrew.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateProfileJob(
        request: zio.aws.databrew.model.UpdateProfileJobRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[UpdateProfileJobRequest, UpdateProfileJobResponse](
        "updateProfileJob",
        api.updateProfileJob
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.UpdateProfileJobResponse.wrap)
        .provideEnvironment(r)
    def createRecipeJob(
        request: zio.aws.databrew.model.CreateRecipeJobRequest
    ): IO[AwsError, zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly] =
      asyncRequestResponse[CreateRecipeJobRequest, CreateRecipeJobResponse](
        "createRecipeJob",
        api.createRecipeJob
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.CreateRecipeJobResponse.wrap)
        .provideEnvironment(r)
    def deleteDataset(
        request: zio.aws.databrew.model.DeleteDatasetRequest
    ): IO[AwsError, zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly] =
      asyncRequestResponse[DeleteDatasetRequest, DeleteDatasetResponse](
        "deleteDataset",
        api.deleteDataset
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DeleteDatasetResponse.wrap)
        .provideEnvironment(r)
    def deleteRecipeVersion(
        request: zio.aws.databrew.model.DeleteRecipeVersionRequest
    ): IO[
      AwsError,
      zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRecipeVersionRequest,
      DeleteRecipeVersionResponse
    ]("deleteRecipeVersion", api.deleteRecipeVersion)(request.buildAwsValue())
      .map(zio.aws.databrew.model.DeleteRecipeVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteProject(
        request: zio.aws.databrew.model.DeleteProjectRequest
    ): IO[AwsError, zio.aws.databrew.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[DeleteProjectRequest, DeleteProjectResponse](
        "deleteProject",
        api.deleteProject
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def deleteSchedule(
        request: zio.aws.databrew.model.DeleteScheduleRequest
    ): IO[AwsError, zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly] =
      asyncRequestResponse[DeleteScheduleRequest, DeleteScheduleResponse](
        "deleteSchedule",
        api.deleteSchedule
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DeleteScheduleResponse.wrap)
        .provideEnvironment(r)
    def startJobRun(
        request: zio.aws.databrew.model.StartJobRunRequest
    ): IO[AwsError, zio.aws.databrew.model.StartJobRunResponse.ReadOnly] =
      asyncRequestResponse[StartJobRunRequest, StartJobRunResponse](
        "startJobRun",
        api.startJobRun
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.StartJobRunResponse.wrap)
        .provideEnvironment(r)
    def listRecipeVersions(
        request: zio.aws.databrew.model.ListRecipeVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.Recipe.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListRecipeVersionsRequest,
        ListRecipeVersionsResponse,
        Recipe
      ](
        "listRecipeVersions",
        api.listRecipeVersions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.recipes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.Recipe.wrap(item))
        .provideEnvironment(r)
    def listRecipeVersionsPaginated(
        request: zio.aws.databrew.model.ListRecipeVersionsRequest
    ): IO[
      AwsError,
      zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRecipeVersionsRequest,
      ListRecipeVersionsResponse
    ]("listRecipeVersions", api.listRecipeVersions)(request.buildAwsValue())
      .map(zio.aws.databrew.model.ListRecipeVersionsResponse.wrap)
      .provideEnvironment(r)
    def deleteJob(
        request: zio.aws.databrew.model.DeleteJobRequest
    ): IO[AwsError, zio.aws.databrew.model.DeleteJobResponse.ReadOnly] =
      asyncRequestResponse[DeleteJobRequest, DeleteJobResponse](
        "deleteJob",
        api.deleteJob
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.DeleteJobResponse.wrap)
        .provideEnvironment(r)
    def publishRecipe(
        request: zio.aws.databrew.model.PublishRecipeRequest
    ): IO[AwsError, zio.aws.databrew.model.PublishRecipeResponse.ReadOnly] =
      asyncRequestResponse[PublishRecipeRequest, PublishRecipeResponse](
        "publishRecipe",
        api.publishRecipe
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.PublishRecipeResponse.wrap)
        .provideEnvironment(r)
    def listRecipes(
        request: zio.aws.databrew.model.ListRecipesRequest
    ): ZStream[Any, AwsError, zio.aws.databrew.model.Recipe.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListRecipesRequest,
        ListRecipesResponse,
        Recipe
      ](
        "listRecipes",
        api.listRecipes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.recipes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.databrew.model.Recipe.wrap(item))
        .provideEnvironment(r)
    def listRecipesPaginated(
        request: zio.aws.databrew.model.ListRecipesRequest
    ): IO[AwsError, zio.aws.databrew.model.ListRecipesResponse.ReadOnly] =
      asyncRequestResponse[ListRecipesRequest, ListRecipesResponse](
        "listRecipes",
        api.listRecipes
      )(request.buildAwsValue())
        .map(zio.aws.databrew.model.ListRecipesResponse.wrap)
        .provideEnvironment(r)
  }
  def createDataset(request: zio.aws.databrew.model.CreateDatasetRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def batchDeleteRecipeVersion(
      request: zio.aws.databrew.model.BatchDeleteRecipeVersionRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.BatchDeleteRecipeVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteRecipeVersion(request))
  def describeJob(request: zio.aws.databrew.model.DescribeJobRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJob(request))
  def createSchedule(
      request: zio.aws.databrew.model.CreateScheduleRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchedule(request))
  def listSchedules(
      request: zio.aws.databrew.model.ListSchedulesRequest
  ): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.Schedule.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchedules(request))
  def listSchedulesPaginated(
      request: zio.aws.databrew.model.ListSchedulesRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListSchedulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSchedulesPaginated(request))
  def updateProject(request: zio.aws.databrew.model.UpdateProjectRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def describeJobRun(
      request: zio.aws.databrew.model.DescribeJobRunRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeJobRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJobRun(request))
  def listJobRuns(request: zio.aws.databrew.model.ListJobRunsRequest): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.JobRun.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobRuns(request))
  def listJobRunsPaginated(
      request: zio.aws.databrew.model.ListJobRunsRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListJobRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobRunsPaginated(request))
  def createRuleset(request: zio.aws.databrew.model.CreateRulesetRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateRulesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRuleset(request))
  def updateSchedule(
      request: zio.aws.databrew.model.UpdateScheduleRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UpdateScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSchedule(request))
  def deleteRuleset(request: zio.aws.databrew.model.DeleteRulesetRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DeleteRulesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRuleset(request))
  def stopJobRun(request: zio.aws.databrew.model.StopJobRunRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.StopJobRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopJobRun(request))
  def listRulesets(
      request: zio.aws.databrew.model.ListRulesetsRequest
  ): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.RulesetItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listRulesets(request))
  def listRulesetsPaginated(
      request: zio.aws.databrew.model.ListRulesetsRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListRulesetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRulesetsPaginated(request))
  def describeDataset(
      request: zio.aws.databrew.model.DescribeDatasetRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def listProjects(
      request: zio.aws.databrew.model.ListProjectsRequest
  ): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.Project.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(
      request: zio.aws.databrew.model.ListProjectsRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def createProfileJob(
      request: zio.aws.databrew.model.CreateProfileJobRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateProfileJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProfileJob(request))
  def describeRecipe(
      request: zio.aws.databrew.model.DescribeRecipeRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecipe(request))
  def updateRecipeJob(
      request: zio.aws.databrew.model.UpdateRecipeJobRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UpdateRecipeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRecipeJob(request))
  def updateDataset(request: zio.aws.databrew.model.UpdateDatasetRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataset(request))
  def describeRuleset(
      request: zio.aws.databrew.model.DescribeRulesetRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRuleset(request))
  def untagResource(request: zio.aws.databrew.model.UntagResourceRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(request: zio.aws.databrew.model.CreateProjectRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def sendProjectSessionAction(
      request: zio.aws.databrew.model.SendProjectSessionActionRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.SendProjectSessionActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendProjectSessionAction(request))
  def startProjectSession(
      request: zio.aws.databrew.model.StartProjectSessionRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.StartProjectSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startProjectSession(request))
  def describeSchedule(
      request: zio.aws.databrew.model.DescribeScheduleRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchedule(request))
  def updateRecipe(request: zio.aws.databrew.model.UpdateRecipeRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRecipe(request))
  def listDatasets(
      request: zio.aws.databrew.model.ListDatasetsRequest
  ): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.Dataset.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(
      request: zio.aws.databrew.model.ListDatasetsRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def updateRuleset(request: zio.aws.databrew.model.UpdateRulesetRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.UpdateRulesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRuleset(request))
  def listTagsForResource(
      request: zio.aws.databrew.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def createRecipe(request: zio.aws.databrew.model.CreateRecipeRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRecipe(request))
  def describeProject(
      request: zio.aws.databrew.model.DescribeProjectRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DescribeProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProject(request))
  def listJobs(request: zio.aws.databrew.model.ListJobsRequest): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.Job.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: zio.aws.databrew.model.ListJobsRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def tagResource(request: zio.aws.databrew.model.TagResourceRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateProfileJob(
      request: zio.aws.databrew.model.UpdateProfileJobRequest
  ): ZIO[zio.aws.databrew.DataBrew, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateProfileJob(request))
  def createRecipeJob(
      request: zio.aws.databrew.model.CreateRecipeJobRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRecipeJob(request))
  def deleteDataset(request: zio.aws.databrew.model.DeleteDatasetRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataset(request))
  def deleteRecipeVersion(
      request: zio.aws.databrew.model.DeleteRecipeVersionRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRecipeVersion(request))
  def deleteProject(request: zio.aws.databrew.model.DeleteProjectRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def deleteSchedule(
      request: zio.aws.databrew.model.DeleteScheduleRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DeleteScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSchedule(request))
  def startJobRun(request: zio.aws.databrew.model.StartJobRunRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.StartJobRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startJobRun(request))
  def listRecipeVersions(
      request: zio.aws.databrew.model.ListRecipeVersionsRequest
  ): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.Recipe.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecipeVersions(request))
  def listRecipeVersionsPaginated(
      request: zio.aws.databrew.model.ListRecipeVersionsRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListRecipeVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecipeVersionsPaginated(request))
  def deleteJob(request: zio.aws.databrew.model.DeleteJobRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.DeleteJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteJob(request))
  def publishRecipe(request: zio.aws.databrew.model.PublishRecipeRequest): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.PublishRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishRecipe(request))
  def listRecipes(request: zio.aws.databrew.model.ListRecipesRequest): ZStream[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.Recipe.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecipes(request))
  def listRecipesPaginated(
      request: zio.aws.databrew.model.ListRecipesRequest
  ): ZIO[
    zio.aws.databrew.DataBrew,
    AwsError,
    zio.aws.databrew.model.ListRecipesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecipesPaginated(request))
}
