package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{Key, Bucket}
import scala.jdk.CollectionConverters._
final case class S3Location(bucket: Bucket, key: Option[Key] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.S3Location
      .builder()
      .bucket(Bucket.unwrap(bucket): java.lang.String)
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.S3Location.ReadOnly =
    zio.aws.databrew.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.S3Location =
      zio.aws.databrew.model.S3Location(bucket, key.map(value => value))
    def bucket: Bucket
    def key: Option[Key]
    def getBucket: ZIO[Any, Nothing, Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.S3Location
  ) extends zio.aws.databrew.model.S3Location.ReadOnly {
    override val bucket: Bucket =
      zio.aws.databrew.model.primitives.Bucket(impl.bucket())
    override val key: Option[Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.databrew.model.primitives.Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.S3Location
  ): zio.aws.databrew.model.S3Location.ReadOnly = new Wrapper(impl)
}
