package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputFormatOptions(
    csv: Option[zio.aws.databrew.model.CsvOutputOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.OutputFormatOptions = {
    import OutputFormatOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.OutputFormatOptions
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.OutputFormatOptions.ReadOnly =
    zio.aws.databrew.model.OutputFormatOptions.wrap(buildAwsValue())
}
object OutputFormatOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.OutputFormatOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.OutputFormatOptions =
      zio.aws.databrew.model
        .OutputFormatOptions(csv.map(value => value.asEditable))
    def csv: Option[zio.aws.databrew.model.CsvOutputOptions.ReadOnly]
    def getCsv
        : ZIO[Any, AwsError, zio.aws.databrew.model.CsvOutputOptions.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.OutputFormatOptions
  ) extends zio.aws.databrew.model.OutputFormatOptions.ReadOnly {
    override val csv: Option[zio.aws.databrew.model.CsvOutputOptions.ReadOnly] =
      scala
        .Option(impl.csv())
        .map(value => zio.aws.databrew.model.CsvOutputOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.OutputFormatOptions
  ): zio.aws.databrew.model.OutputFormatOptions.ReadOnly = new Wrapper(impl)
}
