package zio.aws.databrew.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databrew.model.primitives.{
  ColumnRange,
  RowRange,
  ColumnName,
  StartColumnIndex,
  StartRowIndex
}
import scala.jdk.CollectionConverters._
final case class ViewFrame(
    startColumnIndex: StartColumnIndex,
    columnRange: Option[ColumnRange] = None,
    hiddenColumns: Option[Iterable[ColumnName]] = None,
    startRowIndex: Option[StartRowIndex] = None,
    rowRange: Option[RowRange] = None,
    analytics: Option[zio.aws.databrew.model.AnalyticsMode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ViewFrame = {
    import ViewFrame.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ViewFrame
      .builder()
      .startColumnIndex(StartColumnIndex.unwrap(startColumnIndex): Integer)
      .optionallyWith(
        columnRange.map(value => ColumnRange.unwrap(value): Integer)
      )(_.columnRange)
      .optionallyWith(
        hiddenColumns.map(value =>
          value.map { item =>
            ColumnName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hiddenColumns)
      .optionallyWith(
        startRowIndex.map(value => StartRowIndex.unwrap(value): Integer)
      )(_.startRowIndex)
      .optionallyWith(rowRange.map(value => RowRange.unwrap(value): Integer))(
        _.rowRange
      )
      .optionallyWith(analytics.map(value => value.unwrap))(_.analytics)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ViewFrame.ReadOnly =
    zio.aws.databrew.model.ViewFrame.wrap(buildAwsValue())
}
object ViewFrame {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ViewFrame
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ViewFrame =
      zio.aws.databrew.model.ViewFrame(
        startColumnIndex,
        columnRange.map(value => value),
        hiddenColumns.map(value => value),
        startRowIndex.map(value => value),
        rowRange.map(value => value),
        analytics.map(value => value)
      )
    def startColumnIndex: StartColumnIndex
    def columnRange: Option[ColumnRange]
    def hiddenColumns: Option[List[ColumnName]]
    def startRowIndex: Option[StartRowIndex]
    def rowRange: Option[RowRange]
    def analytics: Option[zio.aws.databrew.model.AnalyticsMode]
    def getStartColumnIndex: ZIO[Any, Nothing, StartColumnIndex] =
      ZIO.succeed(startColumnIndex)
    def getColumnRange: ZIO[Any, AwsError, ColumnRange] =
      AwsError.unwrapOptionField("columnRange", columnRange)
    def getHiddenColumns: ZIO[Any, AwsError, List[ColumnName]] =
      AwsError.unwrapOptionField("hiddenColumns", hiddenColumns)
    def getStartRowIndex: ZIO[Any, AwsError, StartRowIndex] =
      AwsError.unwrapOptionField("startRowIndex", startRowIndex)
    def getRowRange: ZIO[Any, AwsError, RowRange] =
      AwsError.unwrapOptionField("rowRange", rowRange)
    def getAnalytics: ZIO[Any, AwsError, zio.aws.databrew.model.AnalyticsMode] =
      AwsError.unwrapOptionField("analytics", analytics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ViewFrame
  ) extends zio.aws.databrew.model.ViewFrame.ReadOnly {
    override val startColumnIndex: StartColumnIndex =
      zio.aws.databrew.model.primitives
        .StartColumnIndex(impl.startColumnIndex())
    override val columnRange: Option[ColumnRange] = scala
      .Option(impl.columnRange())
      .map(value => zio.aws.databrew.model.primitives.ColumnRange(value))
    override val hiddenColumns: Option[List[ColumnName]] = scala
      .Option(impl.hiddenColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databrew.model.primitives.ColumnName(item)
        }.toList
      )
    override val startRowIndex: Option[StartRowIndex] = scala
      .Option(impl.startRowIndex())
      .map(value => zio.aws.databrew.model.primitives.StartRowIndex(value))
    override val rowRange: Option[RowRange] = scala
      .Option(impl.rowRange())
      .map(value => zio.aws.databrew.model.primitives.RowRange(value))
    override val analytics: Option[zio.aws.databrew.model.AnalyticsMode] = scala
      .Option(impl.analytics())
      .map(value => zio.aws.databrew.model.AnalyticsMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ViewFrame
  ): zio.aws.databrew.model.ViewFrame.ReadOnly = new Wrapper(impl)
}
