package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriptionsToEventBridgeResponse(
    result: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse = {
    import UpdateSubscriptionsToEventBridgeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse
      .builder()
      .optionallyWith(result.map(value => value: java.lang.String))(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly =
    zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse
      .wrap(buildAwsValue())
}
object UpdateSubscriptionsToEventBridgeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse =
      zio.aws.databasemigration.model
        .UpdateSubscriptionsToEventBridgeResponse(result.map(value => value))
    def result: Optional[String]
    def getResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse
  ) extends zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly {
    override val result: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse
  ): zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly =
    new Wrapper(impl)
}
