package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters.*
final case class UpdateSubscriptionsToEventBridgeRequest(
    forceMove: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest = {
    import UpdateSubscriptionsToEventBridgeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
      .builder()
      .optionallyWith(forceMove.map(value => value: java.lang.Boolean))(
        _.forceMove
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest.ReadOnly =
    zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
      .wrap(buildAwsValue())
}
object UpdateSubscriptionsToEventBridgeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest =
      zio.aws.databasemigration.model
        .UpdateSubscriptionsToEventBridgeRequest(forceMove.map(value => value))
    def forceMove: Optional[BooleanOptional]
    def getForceMove: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("forceMove", forceMove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ) extends zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest.ReadOnly {
    override val forceMove: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.forceMove())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ): zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest.ReadOnly =
    new Wrapper(impl)
}
