package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait TlogAccessMode {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.TlogAccessMode
}
object TlogAccessMode {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.TlogAccessMode
  ): zio.aws.databasemigration.model.TlogAccessMode = value match {
    case software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.BACKUP_ONLY =>
      val r = BackupOnly
      r
    case software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.PREFER_BACKUP =>
      val r = PreferBackup
      r
    case software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.PREFER_TLOG =>
      val r = PreferTlog
      r
    case software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.TLOG_ONLY =>
      val r = TlogOnly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.TlogAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TlogAccessMode =
      software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.UNKNOWN_TO_SDK_VERSION
  }
  case object BackupOnly
      extends zio.aws.databasemigration.model.TlogAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TlogAccessMode =
      software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.BACKUP_ONLY
  }
  case object PreferBackup
      extends zio.aws.databasemigration.model.TlogAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TlogAccessMode =
      software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.PREFER_BACKUP
  }
  case object PreferTlog
      extends zio.aws.databasemigration.model.TlogAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TlogAccessMode =
      software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.PREFER_TLOG
  }
  case object TlogOnly extends zio.aws.databasemigration.model.TlogAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.TlogAccessMode =
      software.amazon.awssdk.services.databasemigration.model.TlogAccessMode.TLOG_ONLY
  }
}
