package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TimestreamSettings(
    databaseName: String,
    memoryDuration: IntegerOptional,
    magneticDuration: IntegerOptional,
    cdcInsertsAndUpdates: Optional[BooleanOptional] = Optional.Absent,
    enableMagneticStoreWrites: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.TimestreamSettings = {
    import TimestreamSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.TimestreamSettings
      .builder()
      .databaseName(databaseName: java.lang.String)
      .memoryDuration(memoryDuration: Integer)
      .magneticDuration(magneticDuration: Integer)
      .optionallyWith(
        cdcInsertsAndUpdates.map(value => value: java.lang.Boolean)
      )(_.cdcInsertsAndUpdates)
      .optionallyWith(
        enableMagneticStoreWrites.map(value => value: java.lang.Boolean)
      )(_.enableMagneticStoreWrites)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.TimestreamSettings.ReadOnly =
    zio.aws.databasemigration.model.TimestreamSettings.wrap(buildAwsValue())
}
object TimestreamSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.TimestreamSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.TimestreamSettings =
      zio.aws.databasemigration.model.TimestreamSettings(
        databaseName,
        memoryDuration,
        magneticDuration,
        cdcInsertsAndUpdates.map(value => value),
        enableMagneticStoreWrites.map(value => value)
      )
    def databaseName: String
    def memoryDuration: IntegerOptional
    def magneticDuration: IntegerOptional
    def cdcInsertsAndUpdates: Optional[BooleanOptional]
    def enableMagneticStoreWrites: Optional[BooleanOptional]
    def getDatabaseName: ZIO[Any, Nothing, String] = ZIO.succeed(databaseName)
    def getMemoryDuration: ZIO[Any, Nothing, IntegerOptional] =
      ZIO.succeed(memoryDuration)
    def getMagneticDuration: ZIO[Any, Nothing, IntegerOptional] =
      ZIO.succeed(magneticDuration)
    def getCdcInsertsAndUpdates: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("cdcInsertsAndUpdates", cdcInsertsAndUpdates)
    def getEnableMagneticStoreWrites: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableMagneticStoreWrites",
        enableMagneticStoreWrites
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.TimestreamSettings
  ) extends zio.aws.databasemigration.model.TimestreamSettings.ReadOnly {
    override val databaseName: String = impl.databaseName(): String
    override val memoryDuration: IntegerOptional =
      impl.memoryDuration(): IntegerOptional
    override val magneticDuration: IntegerOptional =
      impl.magneticDuration(): IntegerOptional
    override val cdcInsertsAndUpdates: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcInsertsAndUpdates())
        .map(value => value: BooleanOptional)
    override val enableMagneticStoreWrites: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableMagneticStoreWrites())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.TimestreamSettings
  ): zio.aws.databasemigration.model.TimestreamSettings.ReadOnly = new Wrapper(
    impl
  )
}
