package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TableToReload(schemaName: String, tableName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.TableToReload = {
    import TableToReload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.TableToReload
      .builder()
      .schemaName(schemaName: java.lang.String)
      .tableName(tableName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.TableToReload.ReadOnly =
    zio.aws.databasemigration.model.TableToReload.wrap(buildAwsValue())
}
object TableToReload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.TableToReload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.TableToReload =
      zio.aws.databasemigration.model.TableToReload(schemaName, tableName)
    def schemaName: String
    def tableName: String
    def getSchemaName: ZIO[Any, Nothing, String] = ZIO.succeed(schemaName)
    def getTableName: ZIO[Any, Nothing, String] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.TableToReload
  ) extends zio.aws.databasemigration.model.TableToReload.ReadOnly {
    override val schemaName: String = impl.schemaName(): String
    override val tableName: String = impl.tableName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.TableToReload
  ): zio.aws.databasemigration.model.TableToReload.ReadOnly = new Wrapper(impl)
}
