package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopReplicationTaskResponse(
    replicationTask: Optional[zio.aws.databasemigration.model.ReplicationTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse = {
    import StopReplicationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly =
    zio.aws.databasemigration.model.StopReplicationTaskResponse
      .wrap(buildAwsValue())
}
object StopReplicationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StopReplicationTaskResponse =
      zio.aws.databasemigration.model.StopReplicationTaskResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse
  ) extends zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly {
    override val replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse
  ): zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
