package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopReplicationResponse(
    replication: Optional[zio.aws.databasemigration.model.Replication] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse = {
    import StopReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse
      .builder()
      .optionallyWith(replication.map(value => value.buildAwsValue()))(
        _.replication
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly =
    zio.aws.databasemigration.model.StopReplicationResponse
      .wrap(buildAwsValue())
}
object StopReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.StopReplicationResponse =
      zio.aws.databasemigration.model
        .StopReplicationResponse(replication.map(value => value.asEditable))
    def replication
        : Optional[zio.aws.databasemigration.model.Replication.ReadOnly]
    def getReplication: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Replication.ReadOnly
    ] = AwsError.unwrapOptionField("replication", replication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse
  ) extends zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly {
    override val replication
        : Optional[zio.aws.databasemigration.model.Replication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replication())
        .map(value => zio.aws.databasemigration.model.Replication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse
  ): zio.aws.databasemigration.model.StopReplicationResponse.ReadOnly =
    new Wrapper(impl)
}
