package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopDataMigrationResponse(
    dataMigration: Optional[zio.aws.databasemigration.model.DataMigration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse = {
    import StopDataMigrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse
      .builder()
      .optionallyWith(dataMigration.map(value => value.buildAwsValue()))(
        _.dataMigration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StopDataMigrationResponse.ReadOnly =
    zio.aws.databasemigration.model.StopDataMigrationResponse
      .wrap(buildAwsValue())
}
object StopDataMigrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.StopDataMigrationResponse =
      zio.aws.databasemigration.model
        .StopDataMigrationResponse(dataMigration.map(value => value.asEditable))
    def dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly]
    def getDataMigration: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ] = AwsError.unwrapOptionField("dataMigration", dataMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse
  ) extends zio.aws.databasemigration.model.StopDataMigrationResponse.ReadOnly {
    override val dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigration())
        .map(value => zio.aws.databasemigration.model.DataMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse
  ): zio.aws.databasemigration.model.StopDataMigrationResponse.ReadOnly =
    new Wrapper(impl)
}
