package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait StartReplicationMigrationTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue
}
object StartReplicationMigrationTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue
  ): zio.aws.databasemigration.model.StartReplicationMigrationTypeValue =
    value match {
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.RELOAD_TARGET =>
        val r = `reload-target`
        r
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.RESUME_PROCESSING =>
        val r = `resume-processing`
        r
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.START_REPLICATION =>
        val r = `start-replication`
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.StartReplicationMigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `reload-target`
      extends zio.aws.databasemigration.model.StartReplicationMigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.RELOAD_TARGET
  }
  case object `resume-processing`
      extends zio.aws.databasemigration.model.StartReplicationMigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.RESUME_PROCESSING
  }
  case object `start-replication`
      extends zio.aws.databasemigration.model.StartReplicationMigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationMigrationTypeValue.START_REPLICATION
  }
}
