package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartMetadataModelImportRequest(
    migrationProjectIdentifier: String,
    selectionRules: String,
    origin: zio.aws.databasemigration.model.OriginTypeValue,
    refresh: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest = {
    import StartMetadataModelImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .selectionRules(selectionRules: java.lang.String)
      .origin(origin.unwrap)
      .optionallyWith(refresh.map(value => value: java.lang.Boolean))(_.refresh)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelImportRequest.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelImportRequest
      .wrap(buildAwsValue())
}
object StartMetadataModelImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelImportRequest =
      zio.aws.databasemigration.model.StartMetadataModelImportRequest(
        migrationProjectIdentifier,
        selectionRules,
        origin,
        refresh.map(value => value)
      )
    def migrationProjectIdentifier: String
    def selectionRules: String
    def origin: zio.aws.databasemigration.model.OriginTypeValue
    def refresh: Optional[Boolean]
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getSelectionRules: ZIO[Any, Nothing, String] =
      ZIO.succeed(selectionRules)
    def getOrigin
        : ZIO[Any, Nothing, zio.aws.databasemigration.model.OriginTypeValue] =
      ZIO.succeed(origin)
    def getRefresh: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("refresh", refresh)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest
  ) extends zio.aws.databasemigration.model.StartMetadataModelImportRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val selectionRules: String = impl.selectionRules(): String
    override val origin: zio.aws.databasemigration.model.OriginTypeValue =
      zio.aws.databasemigration.model.OriginTypeValue.wrap(impl.origin())
    override val refresh: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.refresh())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest
  ): zio.aws.databasemigration.model.StartMetadataModelImportRequest.ReadOnly =
    new Wrapper(impl)
}
