package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartMetadataModelExportToTargetResponse(
    requestIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse = {
    import StartMetadataModelExportToTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse
      .builder()
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse
      .wrap(buildAwsValue())
}
object StartMetadataModelExportToTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse =
      zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse(
        requestIdentifier.map(value => value)
      )
    def requestIdentifier: Optional[String]
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse
  ) extends zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly {
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse
  ): zio.aws.databasemigration.model.StartMetadataModelExportToTargetResponse.ReadOnly =
    new Wrapper(impl)
}
