package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartMetadataModelExportAsScriptResponse(
    requestIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse = {
    import StartMetadataModelExportAsScriptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse
      .builder()
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse
      .wrap(buildAwsValue())
}
object StartMetadataModelExportAsScriptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse =
      zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse(
        requestIdentifier.map(value => value)
      )
    def requestIdentifier: Optional[String]
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse
  ) extends zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse.ReadOnly {
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse
  ): zio.aws.databasemigration.model.StartMetadataModelExportAsScriptResponse.ReadOnly =
    new Wrapper(impl)
}
