package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartMetadataModelExportAsScriptRequest(
    migrationProjectIdentifier: String,
    selectionRules: String,
    origin: zio.aws.databasemigration.model.OriginTypeValue,
    fileName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest = {
    import StartMetadataModelExportAsScriptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .selectionRules(selectionRules: java.lang.String)
      .origin(origin.unwrap)
      .optionallyWith(fileName.map(value => value: java.lang.String))(
        _.fileName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest
      .wrap(buildAwsValue())
}
object StartMetadataModelExportAsScriptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest =
      zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest(
        migrationProjectIdentifier,
        selectionRules,
        origin,
        fileName.map(value => value)
      )
    def migrationProjectIdentifier: String
    def selectionRules: String
    def origin: zio.aws.databasemigration.model.OriginTypeValue
    def fileName: Optional[String]
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getSelectionRules: ZIO[Any, Nothing, String] =
      ZIO.succeed(selectionRules)
    def getOrigin
        : ZIO[Any, Nothing, zio.aws.databasemigration.model.OriginTypeValue] =
      ZIO.succeed(origin)
    def getFileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fileName", fileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest
  ) extends zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val selectionRules: String = impl.selectionRules(): String
    override val origin: zio.aws.databasemigration.model.OriginTypeValue =
      zio.aws.databasemigration.model.OriginTypeValue.wrap(impl.origin())
    override val fileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fileName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest
  ): zio.aws.databasemigration.model.StartMetadataModelExportAsScriptRequest.ReadOnly =
    new Wrapper(impl)
}
