package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartMetadataModelAssessmentRequest(
    migrationProjectIdentifier: String,
    selectionRules: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest = {
    import StartMetadataModelAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .selectionRules(selectionRules: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest
      .wrap(buildAwsValue())
}
object StartMetadataModelAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest =
      zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest(
        migrationProjectIdentifier,
        selectionRules
      )
    def migrationProjectIdentifier: String
    def selectionRules: String
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getSelectionRules: ZIO[Any, Nothing, String] =
      ZIO.succeed(selectionRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest
  ) extends zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val selectionRules: String = impl.selectionRules(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest
  ): zio.aws.databasemigration.model.StartMetadataModelAssessmentRequest.ReadOnly =
    new Wrapper(impl)
}
