package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartDataMigrationResponse(
    dataMigration: Optional[zio.aws.databasemigration.model.DataMigration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse = {
    import StartDataMigrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse
      .builder()
      .optionallyWith(dataMigration.map(value => value.buildAwsValue()))(
        _.dataMigration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartDataMigrationResponse.ReadOnly =
    zio.aws.databasemigration.model.StartDataMigrationResponse
      .wrap(buildAwsValue())
}
object StartDataMigrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.StartDataMigrationResponse =
      zio.aws.databasemigration.model.StartDataMigrationResponse(
        dataMigration.map(value => value.asEditable)
      )
    def dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly]
    def getDataMigration: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataMigration.ReadOnly
    ] = AwsError.unwrapOptionField("dataMigration", dataMigration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse
  ) extends zio.aws.databasemigration.model.StartDataMigrationResponse.ReadOnly {
    override val dataMigration
        : Optional[zio.aws.databasemigration.model.DataMigration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataMigration())
        .map(value => zio.aws.databasemigration.model.DataMigration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse
  ): zio.aws.databasemigration.model.StartDataMigrationResponse.ReadOnly =
    new Wrapper(impl)
}
