package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartDataMigrationRequest(
    dataMigrationIdentifier: String,
    startType: zio.aws.databasemigration.model.StartReplicationMigrationTypeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest = {
    import StartDataMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest
      .builder()
      .dataMigrationIdentifier(dataMigrationIdentifier: java.lang.String)
      .startType(startType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartDataMigrationRequest.ReadOnly =
    zio.aws.databasemigration.model.StartDataMigrationRequest
      .wrap(buildAwsValue())
}
object StartDataMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.StartDataMigrationRequest =
      zio.aws.databasemigration.model
        .StartDataMigrationRequest(dataMigrationIdentifier, startType)
    def dataMigrationIdentifier: String
    def startType
        : zio.aws.databasemigration.model.StartReplicationMigrationTypeValue
    def getDataMigrationIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataMigrationIdentifier)
    def getStartType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.StartReplicationMigrationTypeValue
    ] = ZIO.succeed(startType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest
  ) extends zio.aws.databasemigration.model.StartDataMigrationRequest.ReadOnly {
    override val dataMigrationIdentifier: String =
      impl.dataMigrationIdentifier(): String
    override val startType
        : zio.aws.databasemigration.model.StartReplicationMigrationTypeValue =
      zio.aws.databasemigration.model.StartReplicationMigrationTypeValue
        .wrap(impl.startType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest
  ): zio.aws.databasemigration.model.StartDataMigrationRequest.ReadOnly =
    new Wrapper(impl)
}
