package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.Iso8601DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SourceDataSetting(
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStartTime: Optional[Iso8601DateTime] = Optional.Absent,
    cdcStopTime: Optional[Iso8601DateTime] = Optional.Absent,
    slotName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SourceDataSetting = {
    import SourceDataSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SourceDataSetting
      .builder()
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(
        cdcStartTime.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.cdcStartTime)
      .optionallyWith(
        cdcStopTime.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.cdcStopTime)
      .optionallyWith(slotName.map(value => value: java.lang.String))(
        _.slotName
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.SourceDataSetting.ReadOnly =
    zio.aws.databasemigration.model.SourceDataSetting.wrap(buildAwsValue())
}
object SourceDataSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SourceDataSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SourceDataSetting =
      zio.aws.databasemigration.model.SourceDataSetting(
        cdcStartPosition.map(value => value),
        cdcStartTime.map(value => value),
        cdcStopTime.map(value => value),
        slotName.map(value => value)
      )
    def cdcStartPosition: Optional[String]
    def cdcStartTime: Optional[Iso8601DateTime]
    def cdcStopTime: Optional[Iso8601DateTime]
    def slotName: Optional[String]
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStartTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStopTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("cdcStopTime", cdcStopTime)
    def getSlotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotName", slotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SourceDataSetting
  ) extends zio.aws.databasemigration.model.SourceDataSetting.ReadOnly {
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStartTime: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value =>
        zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
      )
    override val cdcStopTime: Optional[Iso8601DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopTime())
      .map(value =>
        zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
      )
    override val slotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SourceDataSetting
  ): zio.aws.databasemigration.model.SourceDataSetting.ReadOnly = new Wrapper(
    impl
  )
}
