package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServerShortInfoResponse(
    serverId: Optional[String] = Optional.Absent,
    ipAddress: Optional[String] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse = {
    import ServerShortInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse
      .builder()
      .optionallyWith(serverId.map(value => value: java.lang.String))(
        _.serverId
      )
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly =
    zio.aws.databasemigration.model.ServerShortInfoResponse
      .wrap(buildAwsValue())
}
object ServerShortInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ServerShortInfoResponse =
      zio.aws.databasemigration.model.ServerShortInfoResponse(
        serverId.map(value => value),
        ipAddress.map(value => value),
        serverName.map(value => value)
      )
    def serverId: Optional[String]
    def ipAddress: Optional[String]
    def serverName: Optional[String]
    def getServerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse
  ) extends zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly {
    override val serverId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => value: String)
    override val ipAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => value: String)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse
  ): zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly =
    new Wrapper(impl)
}
