package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchemaShortInfoResponse(
    schemaId: Optional[String] = Optional.Absent,
    schemaName: Optional[String] = Optional.Absent,
    databaseId: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    databaseIpAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SchemaShortInfoResponse = {
    import SchemaShortInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SchemaShortInfoResponse
      .builder()
      .optionallyWith(schemaId.map(value => value: java.lang.String))(
        _.schemaId
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(databaseId.map(value => value: java.lang.String))(
        _.databaseId
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(databaseIpAddress.map(value => value: java.lang.String))(
        _.databaseIpAddress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.SchemaShortInfoResponse.ReadOnly =
    zio.aws.databasemigration.model.SchemaShortInfoResponse
      .wrap(buildAwsValue())
}
object SchemaShortInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SchemaShortInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SchemaShortInfoResponse =
      zio.aws.databasemigration.model.SchemaShortInfoResponse(
        schemaId.map(value => value),
        schemaName.map(value => value),
        databaseId.map(value => value),
        databaseName.map(value => value),
        databaseIpAddress.map(value => value)
      )
    def schemaId: Optional[String]
    def schemaName: Optional[String]
    def databaseId: Optional[String]
    def databaseName: Optional[String]
    def databaseIpAddress: Optional[String]
    def getSchemaId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaId", schemaId)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getDatabaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDatabaseIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseIpAddress", databaseIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SchemaShortInfoResponse
  ) extends zio.aws.databasemigration.model.SchemaShortInfoResponse.ReadOnly {
    override val schemaId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaId())
      .map(value => value: String)
    override val schemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: String)
    override val databaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val databaseIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseIpAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SchemaShortInfoResponse
  ): zio.aws.databasemigration.model.SchemaShortInfoResponse.ReadOnly =
    new Wrapper(impl)
}
