package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.{DoubleOptional, LongOptional}
import scala.jdk.CollectionConverters.*
final case class SchemaResponse(
    codeLineCount: Optional[LongOptional] = Optional.Absent,
    codeSize: Optional[LongOptional] = Optional.Absent,
    complexity: Optional[String] = Optional.Absent,
    server: Optional[zio.aws.databasemigration.model.ServerShortInfoResponse] =
      Optional.Absent,
    databaseInstance: Optional[
      zio.aws.databasemigration.model.DatabaseShortInfoResponse
    ] = Optional.Absent,
    schemaId: Optional[String] = Optional.Absent,
    schemaName: Optional[String] = Optional.Absent,
    originalSchema: Optional[
      zio.aws.databasemigration.model.SchemaShortInfoResponse
    ] = Optional.Absent,
    similarity: Optional[DoubleOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SchemaResponse = {
    import SchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SchemaResponse
      .builder()
      .optionallyWith(codeLineCount.map(value => value: java.lang.Long))(
        _.codeLineCount
      )
      .optionallyWith(codeSize.map(value => value: java.lang.Long))(_.codeSize)
      .optionallyWith(complexity.map(value => value: java.lang.String))(
        _.complexity
      )
      .optionallyWith(server.map(value => value.buildAwsValue()))(_.server)
      .optionallyWith(databaseInstance.map(value => value.buildAwsValue()))(
        _.databaseInstance
      )
      .optionallyWith(schemaId.map(value => value: java.lang.String))(
        _.schemaId
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(originalSchema.map(value => value.buildAwsValue()))(
        _.originalSchema
      )
      .optionallyWith(similarity.map(value => value: java.lang.Double))(
        _.similarity
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.SchemaResponse.ReadOnly =
    zio.aws.databasemigration.model.SchemaResponse.wrap(buildAwsValue())
}
object SchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SchemaResponse =
      zio.aws.databasemigration.model.SchemaResponse(
        codeLineCount.map(value => value),
        codeSize.map(value => value),
        complexity.map(value => value),
        server.map(value => value.asEditable),
        databaseInstance.map(value => value.asEditable),
        schemaId.map(value => value),
        schemaName.map(value => value),
        originalSchema.map(value => value.asEditable),
        similarity.map(value => value)
      )
    def codeLineCount: Optional[LongOptional]
    def codeSize: Optional[LongOptional]
    def complexity: Optional[String]
    def server: Optional[
      zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly
    ]
    def databaseInstance: Optional[
      zio.aws.databasemigration.model.DatabaseShortInfoResponse.ReadOnly
    ]
    def schemaId: Optional[String]
    def schemaName: Optional[String]
    def originalSchema: Optional[
      zio.aws.databasemigration.model.SchemaShortInfoResponse.ReadOnly
    ]
    def similarity: Optional[DoubleOptional]
    def getCodeLineCount: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("codeLineCount", codeLineCount)
    def getCodeSize: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("codeSize", codeSize)
    def getComplexity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("complexity", complexity)
    def getServer: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly
    ] = AwsError.unwrapOptionField("server", server)
    def getDatabaseInstance: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatabaseShortInfoResponse.ReadOnly
    ] = AwsError.unwrapOptionField("databaseInstance", databaseInstance)
    def getSchemaId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaId", schemaId)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getOriginalSchema: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SchemaShortInfoResponse.ReadOnly
    ] = AwsError.unwrapOptionField("originalSchema", originalSchema)
    def getSimilarity: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("similarity", similarity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SchemaResponse
  ) extends zio.aws.databasemigration.model.SchemaResponse.ReadOnly {
    override val codeLineCount: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.codeLineCount())
      .map(value => value: LongOptional)
    override val codeSize: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSize())
      .map(value => value: LongOptional)
    override val complexity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.complexity())
      .map(value => value: String)
    override val server: Optional[
      zio.aws.databasemigration.model.ServerShortInfoResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.server())
      .map(value =>
        zio.aws.databasemigration.model.ServerShortInfoResponse.wrap(value)
      )
    override val databaseInstance: Optional[
      zio.aws.databasemigration.model.DatabaseShortInfoResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseInstance())
      .map(value =>
        zio.aws.databasemigration.model.DatabaseShortInfoResponse.wrap(value)
      )
    override val schemaId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaId())
      .map(value => value: String)
    override val schemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: String)
    override val originalSchema: Optional[
      zio.aws.databasemigration.model.SchemaShortInfoResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originalSchema())
      .map(value =>
        zio.aws.databasemigration.model.SchemaShortInfoResponse.wrap(value)
      )
    override val similarity: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.similarity())
      .map(value => value: DoubleOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SchemaResponse
  ): zio.aws.databasemigration.model.SchemaResponse.ReadOnly = new Wrapper(impl)
}
