package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SCApplicationAttributes(
    s3BucketPath: Optional[String] = Optional.Absent,
    s3BucketRoleArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes = {
    import SCApplicationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes
      .builder()
      .optionallyWith(s3BucketPath.map(value => value: java.lang.String))(
        _.s3BucketPath
      )
      .optionallyWith(s3BucketRoleArn.map(value => value: java.lang.String))(
        _.s3BucketRoleArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly =
    zio.aws.databasemigration.model.SCApplicationAttributes
      .wrap(buildAwsValue())
}
object SCApplicationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SCApplicationAttributes =
      zio.aws.databasemigration.model.SCApplicationAttributes(
        s3BucketPath.map(value => value),
        s3BucketRoleArn.map(value => value)
      )
    def s3BucketPath: Optional[String]
    def s3BucketRoleArn: Optional[String]
    def getS3BucketPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketPath", s3BucketPath)
    def getS3BucketRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketRoleArn", s3BucketRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes
  ) extends zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly {
    override val s3BucketPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketPath())
      .map(value => value: String)
    override val s3BucketRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketRoleArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes
  ): zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly =
    new Wrapper(impl)
}
