package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicationTaskAssessmentRun(
    replicationTaskAssessmentRunArn: Optional[String] = Optional.Absent,
    replicationTaskArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    replicationTaskAssessmentRunCreationDate: Optional[TStamp] =
      Optional.Absent,
    assessmentProgress: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress
    ] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    resultLocationBucket: Optional[String] = Optional.Absent,
    resultLocationFolder: Optional[String] = Optional.Absent,
    resultEncryptionMode: Optional[String] = Optional.Absent,
    resultKmsKeyArn: Optional[String] = Optional.Absent,
    assessmentRunName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun = {
    import ReplicationTaskAssessmentRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
      .builder()
      .optionallyWith(
        replicationTaskAssessmentRunArn.map(value => value: java.lang.String)
      )(_.replicationTaskAssessmentRunArn)
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        replicationTaskAssessmentRunCreationDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.replicationTaskAssessmentRunCreationDate)
      .optionallyWith(assessmentProgress.map(value => value.buildAwsValue()))(
        _.assessmentProgress
      )
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        resultLocationBucket.map(value => value: java.lang.String)
      )(_.resultLocationBucket)
      .optionallyWith(
        resultLocationFolder.map(value => value: java.lang.String)
      )(_.resultLocationFolder)
      .optionallyWith(
        resultEncryptionMode.map(value => value: java.lang.String)
      )(_.resultEncryptionMode)
      .optionallyWith(resultKmsKeyArn.map(value => value: java.lang.String))(
        _.resultKmsKeyArn
      )
      .optionallyWith(assessmentRunName.map(value => value: java.lang.String))(
        _.assessmentRunName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskAssessmentRun
      .wrap(buildAwsValue())
}
object ReplicationTaskAssessmentRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationTaskAssessmentRun =
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun(
        replicationTaskAssessmentRunArn.map(value => value),
        replicationTaskArn.map(value => value),
        status.map(value => value),
        replicationTaskAssessmentRunCreationDate.map(value => value),
        assessmentProgress.map(value => value.asEditable),
        lastFailureMessage.map(value => value),
        serviceAccessRoleArn.map(value => value),
        resultLocationBucket.map(value => value),
        resultLocationFolder.map(value => value),
        resultEncryptionMode.map(value => value),
        resultKmsKeyArn.map(value => value),
        assessmentRunName.map(value => value)
      )
    def replicationTaskAssessmentRunArn: Optional[String]
    def replicationTaskArn: Optional[String]
    def status: Optional[String]
    def replicationTaskAssessmentRunCreationDate: Optional[TStamp]
    def assessmentProgress: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly
    ]
    def lastFailureMessage: Optional[String]
    def serviceAccessRoleArn: Optional[String]
    def resultLocationBucket: Optional[String]
    def resultLocationFolder: Optional[String]
    def resultEncryptionMode: Optional[String]
    def resultKmsKeyArn: Optional[String]
    def assessmentRunName: Optional[String]
    def getReplicationTaskAssessmentRunArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationTaskAssessmentRunArn",
        replicationTaskAssessmentRunArn
      )
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReplicationTaskAssessmentRunCreationDate
        : ZIO[Any, AwsError, TStamp] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentRunCreationDate",
      replicationTaskAssessmentRunCreationDate
    )
    def getAssessmentProgress: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly
    ] = AwsError.unwrapOptionField("assessmentProgress", assessmentProgress)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getResultLocationBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultLocationBucket", resultLocationBucket)
    def getResultLocationFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultLocationFolder", resultLocationFolder)
    def getResultEncryptionMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultEncryptionMode", resultEncryptionMode)
    def getResultKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultKmsKeyArn", resultKmsKeyArn)
    def getAssessmentRunName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentRunName", assessmentRunName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
  ) extends zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly {
    override val replicationTaskAssessmentRunArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskAssessmentRunArn())
        .map(value => value: String)
    override val replicationTaskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val replicationTaskAssessmentRunCreationDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskAssessmentRunCreationDate())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val assessmentProgress: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentProgress())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress
          .wrap(value)
      )
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val resultLocationBucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultLocationBucket())
      .map(value => value: String)
    override val resultLocationFolder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultLocationFolder())
      .map(value => value: String)
    override val resultEncryptionMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultEncryptionMode())
      .map(value => value: String)
    override val resultKmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultKmsKeyArn())
      .map(value => value: String)
    override val assessmentRunName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentRunName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRun
  ): zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly =
    new Wrapper(impl)
}
