package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicationTaskAssessmentResult(
    replicationTaskIdentifier: Optional[String] = Optional.Absent,
    replicationTaskArn: Optional[String] = Optional.Absent,
    replicationTaskLastAssessmentDate: Optional[TStamp] = Optional.Absent,
    assessmentStatus: Optional[String] = Optional.Absent,
    assessmentResultsFile: Optional[String] = Optional.Absent,
    assessmentResults: Optional[String] = Optional.Absent,
    s3ObjectUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult = {
    import ReplicationTaskAssessmentResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
      .builder()
      .optionallyWith(
        replicationTaskIdentifier.map(value => value: java.lang.String)
      )(_.replicationTaskIdentifier)
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(
        replicationTaskLastAssessmentDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.replicationTaskLastAssessmentDate)
      .optionallyWith(assessmentStatus.map(value => value: java.lang.String))(
        _.assessmentStatus
      )
      .optionallyWith(
        assessmentResultsFile.map(value => value: java.lang.String)
      )(_.assessmentResultsFile)
      .optionallyWith(assessmentResults.map(value => value: java.lang.String))(
        _.assessmentResults
      )
      .optionallyWith(s3ObjectUrl.map(value => value: java.lang.String))(
        _.s3ObjectUrl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskAssessmentResult
      .wrap(buildAwsValue())
}
object ReplicationTaskAssessmentResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationTaskAssessmentResult =
      zio.aws.databasemigration.model.ReplicationTaskAssessmentResult(
        replicationTaskIdentifier.map(value => value),
        replicationTaskArn.map(value => value),
        replicationTaskLastAssessmentDate.map(value => value),
        assessmentStatus.map(value => value),
        assessmentResultsFile.map(value => value),
        assessmentResults.map(value => value),
        s3ObjectUrl.map(value => value)
      )
    def replicationTaskIdentifier: Optional[String]
    def replicationTaskArn: Optional[String]
    def replicationTaskLastAssessmentDate: Optional[TStamp]
    def assessmentStatus: Optional[String]
    def assessmentResultsFile: Optional[String]
    def assessmentResults: Optional[String]
    def s3ObjectUrl: Optional[String]
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskIdentifier", replicationTaskIdentifier)
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationTaskLastAssessmentDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationTaskLastAssessmentDate",
        replicationTaskLastAssessmentDate
      )
    def getAssessmentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentStatus", assessmentStatus)
    def getAssessmentResultsFile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentResultsFile", assessmentResultsFile)
    def getAssessmentResults: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("assessmentResults", assessmentResults)
    def getS3ObjectUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3ObjectUrl", s3ObjectUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
  ) extends zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly {
    override val replicationTaskIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskIdentifier())
        .map(value => value: String)
    override val replicationTaskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskArn())
      .map(value => value: String)
    override val replicationTaskLastAssessmentDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskLastAssessmentDate())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val assessmentStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentStatus())
      .map(value => value: String)
    override val assessmentResultsFile: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentResultsFile())
      .map(value => value: String)
    override val assessmentResults: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentResults())
      .map(value => value: String)
    override val s3ObjectUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ObjectUrl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult
  ): zio.aws.databasemigration.model.ReplicationTaskAssessmentResult.ReadOnly =
    new Wrapper(impl)
}
