package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicationTask(
    replicationTaskIdentifier: Optional[String] = Optional.Absent,
    sourceEndpointArn: Optional[String] = Optional.Absent,
    targetEndpointArn: Optional[String] = Optional.Absent,
    replicationInstanceArn: Optional[String] = Optional.Absent,
    migrationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    tableMappings: Optional[String] = Optional.Absent,
    replicationTaskSettings: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent,
    stopReason: Optional[String] = Optional.Absent,
    replicationTaskCreationDate: Optional[TStamp] = Optional.Absent,
    replicationTaskStartDate: Optional[TStamp] = Optional.Absent,
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStopPosition: Optional[String] = Optional.Absent,
    recoveryCheckpoint: Optional[String] = Optional.Absent,
    replicationTaskArn: Optional[String] = Optional.Absent,
    replicationTaskStats: Optional[
      zio.aws.databasemigration.model.ReplicationTaskStats
    ] = Optional.Absent,
    taskData: Optional[String] = Optional.Absent,
    targetReplicationInstanceArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTask = {
    import ReplicationTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTask
      .builder()
      .optionallyWith(
        replicationTaskIdentifier.map(value => value: java.lang.String)
      )(_.replicationTaskIdentifier)
      .optionallyWith(sourceEndpointArn.map(value => value: java.lang.String))(
        _.sourceEndpointArn
      )
      .optionallyWith(targetEndpointArn.map(value => value: java.lang.String))(
        _.targetEndpointArn
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(migrationType.map(value => value.unwrap))(_.migrationType)
      .optionallyWith(tableMappings.map(value => value: java.lang.String))(
        _.tableMappings
      )
      .optionallyWith(
        replicationTaskSettings.map(value => value: java.lang.String)
      )(_.replicationTaskSettings)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(stopReason.map(value => value: java.lang.String))(
        _.stopReason
      )
      .optionallyWith(
        replicationTaskCreationDate.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationTaskCreationDate)
      .optionallyWith(
        replicationTaskStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationTaskStartDate)
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(recoveryCheckpoint.map(value => value: java.lang.String))(
        _.recoveryCheckpoint
      )
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(replicationTaskStats.map(value => value.buildAwsValue()))(
        _.replicationTaskStats
      )
      .optionallyWith(taskData.map(value => value: java.lang.String))(
        _.taskData
      )
      .optionallyWith(
        targetReplicationInstanceArn.map(value => value: java.lang.String)
      )(_.targetReplicationInstanceArn)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ReplicationTask.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTask.wrap(buildAwsValue())
}
object ReplicationTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationTask =
      zio.aws.databasemigration.model.ReplicationTask(
        replicationTaskIdentifier.map(value => value),
        sourceEndpointArn.map(value => value),
        targetEndpointArn.map(value => value),
        replicationInstanceArn.map(value => value),
        migrationType.map(value => value),
        tableMappings.map(value => value),
        replicationTaskSettings.map(value => value),
        status.map(value => value),
        lastFailureMessage.map(value => value),
        stopReason.map(value => value),
        replicationTaskCreationDate.map(value => value),
        replicationTaskStartDate.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        recoveryCheckpoint.map(value => value),
        replicationTaskArn.map(value => value),
        replicationTaskStats.map(value => value.asEditable),
        taskData.map(value => value),
        targetReplicationInstanceArn.map(value => value)
      )
    def replicationTaskIdentifier: Optional[String]
    def sourceEndpointArn: Optional[String]
    def targetEndpointArn: Optional[String]
    def replicationInstanceArn: Optional[String]
    def migrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def tableMappings: Optional[String]
    def replicationTaskSettings: Optional[String]
    def status: Optional[String]
    def lastFailureMessage: Optional[String]
    def stopReason: Optional[String]
    def replicationTaskCreationDate: Optional[TStamp]
    def replicationTaskStartDate: Optional[TStamp]
    def cdcStartPosition: Optional[String]
    def cdcStopPosition: Optional[String]
    def recoveryCheckpoint: Optional[String]
    def replicationTaskArn: Optional[String]
    def replicationTaskStats: Optional[
      zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly
    ]
    def taskData: Optional[String]
    def targetReplicationInstanceArn: Optional[String]
    def getReplicationTaskIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskIdentifier", replicationTaskIdentifier)
    def getSourceEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEndpointArn", sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEndpointArn", targetEndpointArn)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getMigrationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("migrationType", migrationType)
    def getTableMappings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getReplicationTaskSettings: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskSettings", replicationTaskSettings)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getStopReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stopReason", stopReason)
    def getReplicationTaskCreationDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationTaskCreationDate",
        replicationTaskCreationDate
      )
    def getReplicationTaskStartDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("replicationTaskStartDate", replicationTaskStartDate)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getRecoveryCheckpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recoveryCheckpoint", recoveryCheckpoint)
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getReplicationTaskStats: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTaskStats", replicationTaskStats)
    def getTaskData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskData", taskData)
    def getTargetReplicationInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetReplicationInstanceArn",
        targetReplicationInstanceArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTask
  ) extends zio.aws.databasemigration.model.ReplicationTask.ReadOnly {
    override val replicationTaskIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskIdentifier())
        .map(value => value: String)
    override val sourceEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceEndpointArn())
      .map(value => value: String)
    override val targetEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEndpointArn())
      .map(value => value: String)
    override val replicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value => value: String)
    override val migrationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val tableMappings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableMappings())
      .map(value => value: String)
    override val replicationTaskSettings: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskSettings())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
    override val stopReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stopReason())
      .map(value => value: String)
    override val replicationTaskCreationDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskCreationDate())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val replicationTaskStartDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskStartDate())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStopPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopPosition())
      .map(value => value: String)
    override val recoveryCheckpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryCheckpoint())
      .map(value => value: String)
    override val replicationTaskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskArn())
      .map(value => value: String)
    override val replicationTaskStats: Optional[
      zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskStats())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationTaskStats.wrap(value)
      )
    override val taskData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskData())
      .map(value => value: String)
    override val targetReplicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetReplicationInstanceArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTask
  ): zio.aws.databasemigration.model.ReplicationTask.ReadOnly = new Wrapper(
    impl
  )
}
