package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicationConfig(
    replicationConfigIdentifier: Optional[String] = Optional.Absent,
    replicationConfigArn: Optional[String] = Optional.Absent,
    sourceEndpointArn: Optional[String] = Optional.Absent,
    targetEndpointArn: Optional[String] = Optional.Absent,
    replicationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    computeConfig: Optional[zio.aws.databasemigration.model.ComputeConfig] =
      Optional.Absent,
    replicationSettings: Optional[String] = Optional.Absent,
    supplementalSettings: Optional[String] = Optional.Absent,
    tableMappings: Optional[String] = Optional.Absent,
    replicationConfigCreateTime: Optional[TStamp] = Optional.Absent,
    replicationConfigUpdateTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationConfig = {
    import ReplicationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationConfig
      .builder()
      .optionallyWith(
        replicationConfigIdentifier.map(value => value: java.lang.String)
      )(_.replicationConfigIdentifier)
      .optionallyWith(
        replicationConfigArn.map(value => value: java.lang.String)
      )(_.replicationConfigArn)
      .optionallyWith(sourceEndpointArn.map(value => value: java.lang.String))(
        _.sourceEndpointArn
      )
      .optionallyWith(targetEndpointArn.map(value => value: java.lang.String))(
        _.targetEndpointArn
      )
      .optionallyWith(replicationType.map(value => value.unwrap))(
        _.replicationType
      )
      .optionallyWith(computeConfig.map(value => value.buildAwsValue()))(
        _.computeConfig
      )
      .optionallyWith(
        replicationSettings.map(value => value: java.lang.String)
      )(_.replicationSettings)
      .optionallyWith(
        supplementalSettings.map(value => value: java.lang.String)
      )(_.supplementalSettings)
      .optionallyWith(tableMappings.map(value => value: java.lang.String))(
        _.tableMappings
      )
      .optionallyWith(
        replicationConfigCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationConfigCreateTime)
      .optionallyWith(
        replicationConfigUpdateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationConfigUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ReplicationConfig.ReadOnly =
    zio.aws.databasemigration.model.ReplicationConfig.wrap(buildAwsValue())
}
object ReplicationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationConfig =
      zio.aws.databasemigration.model.ReplicationConfig(
        replicationConfigIdentifier.map(value => value),
        replicationConfigArn.map(value => value),
        sourceEndpointArn.map(value => value),
        targetEndpointArn.map(value => value),
        replicationType.map(value => value),
        computeConfig.map(value => value.asEditable),
        replicationSettings.map(value => value),
        supplementalSettings.map(value => value),
        tableMappings.map(value => value),
        replicationConfigCreateTime.map(value => value),
        replicationConfigUpdateTime.map(value => value)
      )
    def replicationConfigIdentifier: Optional[String]
    def replicationConfigArn: Optional[String]
    def sourceEndpointArn: Optional[String]
    def targetEndpointArn: Optional[String]
    def replicationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def computeConfig
        : Optional[zio.aws.databasemigration.model.ComputeConfig.ReadOnly]
    def replicationSettings: Optional[String]
    def supplementalSettings: Optional[String]
    def tableMappings: Optional[String]
    def replicationConfigCreateTime: Optional[TStamp]
    def replicationConfigUpdateTime: Optional[TStamp]
    def getReplicationConfigIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationConfigIdentifier",
        replicationConfigIdentifier
      )
    def getReplicationConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationConfigArn", replicationConfigArn)
    def getSourceEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEndpointArn", sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEndpointArn", targetEndpointArn)
    def getReplicationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("replicationType", replicationType)
    def getComputeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ComputeConfig.ReadOnly
    ] = AwsError.unwrapOptionField("computeConfig", computeConfig)
    def getReplicationSettings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationSettings", replicationSettings)
    def getSupplementalSettings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supplementalSettings", supplementalSettings)
    def getTableMappings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableMappings", tableMappings)
    def getReplicationConfigCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationConfigCreateTime",
        replicationConfigCreateTime
      )
    def getReplicationConfigUpdateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationConfigUpdateTime",
        replicationConfigUpdateTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationConfig
  ) extends zio.aws.databasemigration.model.ReplicationConfig.ReadOnly {
    override val replicationConfigIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigIdentifier())
        .map(value => value: String)
    override val replicationConfigArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfigArn())
      .map(value => value: String)
    override val sourceEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceEndpointArn())
      .map(value => value: String)
    override val targetEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEndpointArn())
      .map(value => value: String)
    override val replicationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val computeConfig
        : Optional[zio.aws.databasemigration.model.ComputeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeConfig())
        .map(value => zio.aws.databasemigration.model.ComputeConfig.wrap(value))
    override val replicationSettings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationSettings())
      .map(value => value: String)
    override val supplementalSettings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementalSettings())
      .map(value => value: String)
    override val tableMappings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableMappings())
      .map(value => value: String)
    override val replicationConfigCreateTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigCreateTime())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val replicationConfigUpdateTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigUpdateTime())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationConfig
  ): zio.aws.databasemigration.model.ReplicationConfig.ReadOnly = new Wrapper(
    impl
  )
}
