package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReloadReplicationTablesResponse(
    replicationConfigArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse = {
    import ReloadReplicationTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse
      .builder()
      .optionallyWith(
        replicationConfigArn.map(value => value: java.lang.String)
      )(_.replicationConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly =
    zio.aws.databasemigration.model.ReloadReplicationTablesResponse
      .wrap(buildAwsValue())
}
object ReloadReplicationTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReloadReplicationTablesResponse =
      zio.aws.databasemigration.model.ReloadReplicationTablesResponse(
        replicationConfigArn.map(value => value)
      )
    def replicationConfigArn: Optional[String]
    def getReplicationConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationConfigArn", replicationConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse
  ) extends zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly {
    override val replicationConfigArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfigArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse
  ): zio.aws.databasemigration.model.ReloadReplicationTablesResponse.ReadOnly =
    new Wrapper(impl)
}
