package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RedshiftDataProviderSettings(
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RedshiftDataProviderSettings = {
    import RedshiftDataProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RedshiftDataProviderSettings
      .builder()
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RedshiftDataProviderSettings.ReadOnly =
    zio.aws.databasemigration.model.RedshiftDataProviderSettings
      .wrap(buildAwsValue())
}
object RedshiftDataProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RedshiftDataProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.RedshiftDataProviderSettings =
      zio.aws.databasemigration.model.RedshiftDataProviderSettings(
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value)
      )
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RedshiftDataProviderSettings
  ) extends zio.aws.databasemigration.model.RedshiftDataProviderSettings.ReadOnly {
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RedshiftDataProviderSettings
  ): zio.aws.databasemigration.model.RedshiftDataProviderSettings.ReadOnly =
    new Wrapper(impl)
}
