package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RecommendationSettings(
    instanceSizingType: String,
    workloadType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RecommendationSettings = {
    import RecommendationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RecommendationSettings
      .builder()
      .instanceSizingType(instanceSizingType: java.lang.String)
      .workloadType(workloadType: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RecommendationSettings.ReadOnly =
    zio.aws.databasemigration.model.RecommendationSettings.wrap(buildAwsValue())
}
object RecommendationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RecommendationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RecommendationSettings =
      zio.aws.databasemigration.model
        .RecommendationSettings(instanceSizingType, workloadType)
    def instanceSizingType: String
    def workloadType: String
    def getInstanceSizingType: ZIO[Any, Nothing, String] =
      ZIO.succeed(instanceSizingType)
    def getWorkloadType: ZIO[Any, Nothing, String] = ZIO.succeed(workloadType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RecommendationSettings
  ) extends zio.aws.databasemigration.model.RecommendationSettings.ReadOnly {
    override val instanceSizingType: String = impl.instanceSizingType(): String
    override val workloadType: String = impl.workloadType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RecommendationSettings
  ): zio.aws.databasemigration.model.RecommendationSettings.ReadOnly =
    new Wrapper(impl)
}
