package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RdsRecommendation(
    requirementsToTarget: Optional[
      zio.aws.databasemigration.model.RdsRequirements
    ] = Optional.Absent,
    targetConfiguration: Optional[
      zio.aws.databasemigration.model.RdsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RdsRecommendation = {
    import RdsRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RdsRecommendation
      .builder()
      .optionallyWith(requirementsToTarget.map(value => value.buildAwsValue()))(
        _.requirementsToTarget
      )
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RdsRecommendation.ReadOnly =
    zio.aws.databasemigration.model.RdsRecommendation.wrap(buildAwsValue())
}
object RdsRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RdsRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RdsRecommendation =
      zio.aws.databasemigration.model.RdsRecommendation(
        requirementsToTarget.map(value => value.asEditable),
        targetConfiguration.map(value => value.asEditable)
      )
    def requirementsToTarget
        : Optional[zio.aws.databasemigration.model.RdsRequirements.ReadOnly]
    def targetConfiguration
        : Optional[zio.aws.databasemigration.model.RdsConfiguration.ReadOnly]
    def getRequirementsToTarget: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RdsRequirements.ReadOnly
    ] = AwsError.unwrapOptionField("requirementsToTarget", requirementsToTarget)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RdsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RdsRecommendation
  ) extends zio.aws.databasemigration.model.RdsRecommendation.ReadOnly {
    override val requirementsToTarget
        : Optional[zio.aws.databasemigration.model.RdsRequirements.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requirementsToTarget())
        .map(value =>
          zio.aws.databasemigration.model.RdsRequirements.wrap(value)
        )
    override val targetConfiguration
        : Optional[zio.aws.databasemigration.model.RdsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetConfiguration())
        .map(value =>
          zio.aws.databasemigration.model.RdsConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RdsRecommendation
  ): zio.aws.databasemigration.model.RdsRecommendation.ReadOnly = new Wrapper(
    impl
  )
}
