package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{TStamp, Integer}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ProvisionData(
    provisionState: Optional[String] = Optional.Absent,
    provisionedCapacityUnits: Optional[Integer] = Optional.Absent,
    dateProvisioned: Optional[TStamp] = Optional.Absent,
    isNewProvisioningAvailable: Optional[Boolean] = Optional.Absent,
    dateNewProvisioningDataAvailable: Optional[TStamp] = Optional.Absent,
    reasonForNewProvisioningData: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ProvisionData = {
    import ProvisionData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ProvisionData
      .builder()
      .optionallyWith(provisionState.map(value => value: java.lang.String))(
        _.provisionState
      )
      .optionallyWith(
        provisionedCapacityUnits.map(value => value: java.lang.Integer)
      )(_.provisionedCapacityUnits)
      .optionallyWith(
        dateProvisioned.map(value => TStamp.unwrap(value): Instant)
      )(_.dateProvisioned)
      .optionallyWith(
        isNewProvisioningAvailable.map(value => value: java.lang.Boolean)
      )(_.isNewProvisioningAvailable)
      .optionallyWith(
        dateNewProvisioningDataAvailable.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.dateNewProvisioningDataAvailable)
      .optionallyWith(
        reasonForNewProvisioningData.map(value => value: java.lang.String)
      )(_.reasonForNewProvisioningData)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ProvisionData.ReadOnly =
    zio.aws.databasemigration.model.ProvisionData.wrap(buildAwsValue())
}
object ProvisionData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ProvisionData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ProvisionData =
      zio.aws.databasemigration.model.ProvisionData(
        provisionState.map(value => value),
        provisionedCapacityUnits.map(value => value),
        dateProvisioned.map(value => value),
        isNewProvisioningAvailable.map(value => value),
        dateNewProvisioningDataAvailable.map(value => value),
        reasonForNewProvisioningData.map(value => value)
      )
    def provisionState: Optional[String]
    def provisionedCapacityUnits: Optional[Integer]
    def dateProvisioned: Optional[TStamp]
    def isNewProvisioningAvailable: Optional[Boolean]
    def dateNewProvisioningDataAvailable: Optional[TStamp]
    def reasonForNewProvisioningData: Optional[String]
    def getProvisionState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provisionState", provisionState)
    def getProvisionedCapacityUnits: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("provisionedCapacityUnits", provisionedCapacityUnits)
    def getDateProvisioned: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("dateProvisioned", dateProvisioned)
    def getIsNewProvisioningAvailable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isNewProvisioningAvailable",
        isNewProvisioningAvailable
      )
    def getDateNewProvisioningDataAvailable: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "dateNewProvisioningDataAvailable",
        dateNewProvisioningDataAvailable
      )
    def getReasonForNewProvisioningData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reasonForNewProvisioningData",
        reasonForNewProvisioningData
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ProvisionData
  ) extends zio.aws.databasemigration.model.ProvisionData.ReadOnly {
    override val provisionState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionState())
      .map(value => value: String)
    override val provisionedCapacityUnits: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedCapacityUnits())
        .map(value => value: Integer)
    override val dateProvisioned: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dateProvisioned())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val isNewProvisioningAvailable: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isNewProvisioningAvailable())
        .map(value => value: Boolean)
    override val dateNewProvisioningDataAvailable: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateNewProvisioningDataAvailable())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val reasonForNewProvisioningData: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reasonForNewProvisioningData())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ProvisionData
  ): zio.aws.databasemigration.model.ProvisionData.ReadOnly = new Wrapper(impl)
}
