package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait OriginTypeValue {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.OriginTypeValue
}
object OriginTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.OriginTypeValue
  ): zio.aws.databasemigration.model.OriginTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.OriginTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.OriginTypeValue.SOURCE =>
      val r = SOURCE
      r
    case software.amazon.awssdk.services.databasemigration.model.OriginTypeValue.TARGET =>
      val r = TARGET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.OriginTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.OriginTypeValue =
      software.amazon.awssdk.services.databasemigration.model.OriginTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object SOURCE extends zio.aws.databasemigration.model.OriginTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.OriginTypeValue =
      software.amazon.awssdk.services.databasemigration.model.OriginTypeValue.SOURCE
  }
  case object TARGET extends zio.aws.databasemigration.model.OriginTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.OriginTypeValue =
      software.amazon.awssdk.services.databasemigration.model.OriginTypeValue.TARGET
  }
}
